import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.*;
import java.awt.Point;
import java.util.*;
//import javax.management.JMRuntimeException;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.picking.behaviors.*;
import com.sun.j3d.utils.picking.*;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.behaviors.vp.*;

import javax.media.j3d.*;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.vecmath.*;


public class ToolTest extends Applet implements ActionListener{

	private Point3d icosahedronCenter = new Point3d(0,0,0);
	private IcosahedronTSA geom;
	private TriangleData[] triangles = new TriangleData[20];
	private JTextArea xarea;
	private JTextArea yarea;
	private JTextArea zarea;
	private BranchGroup scene;
	private BoundingSphere bounds;
	private int triangleFaces = 20;
	private int counter = 0;
	private ConnectSubunits conSubts;
	
	public BranchGroup createSceneGraphic(Canvas3D canvas)
	{
		 BranchGroup objRoot = new BranchGroup();
	     objRoot.setCapability(BranchGroup.ALLOW_DETACH);
	     objRoot.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
	     objRoot.setCapability(Group.ALLOW_CHILDREN_WRITE);

		 TransformGroup objScale = new TransformGroup();
		 Transform3D t3d = new Transform3D();
		 t3d.setScale(1.0);
		 objScale.setTransform(t3d);
		 objRoot.addChild(objScale);		 
		 objScale.addChild(createIcosahedron(1.0, objRoot));
		 
		 bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

		 // Add a light.
		 Color3f lColor = new Color3f(1.0f, 1.0f, 1.0f) ;
		 Vector3f lDir  = new Vector3f(0.0f, 0.0f, -1.0f) ;

		 DirectionalLight lgt = new DirectionalLight(lColor, lDir) ;
		 lgt.setInfluencingBounds(bounds) ;
		 
		 lDir.negate();
		 DirectionalLight lgt2 = new DirectionalLight(lColor, lDir);
		 lgt.setInfluencingBounds(bounds);
		 objRoot.addChild(lgt);
		 objRoot.addChild(lgt2);
		 return objRoot;		 
	}
	
	private Group createIcosahedron(double scale, BranchGroup root)
	{
		
		Shape3D shape = null;		
		// Create a transform group node to scale and position the object.
		Transform3D t = new Transform3D();
		t.set(scale, new Vector3d(icosahedronCenter.x, icosahedronCenter.y, icosahedronCenter.z));
		TransformGroup objTrans = new TransformGroup(t);
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		objTrans.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
		objTrans.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		
		// Create a second transform group node and initialize it to the
		// identity.  Enable the TRANSFORM_WRITE capability so that
		// our behavior code can modify it at runtime.
		TransformGroup spinTg = new TransformGroup();
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		spinTg.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
		
		Appearance appearance = new Appearance();
		geom = new IcosahedronTSA();
		  
		Material m = new Material() ;
		m.setLightingEnable(false) ;
		appearance.setMaterial(m) ;
		  
		shape = new Shape3D(geom,appearance);		 
		shape.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE);
		  
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		shape.setCapability(Shape3D.ENABLE_PICK_REPORTING);
		shape.setPickable(false);
		PickTool.setCapabilities(shape, PickTool.INTERSECT_FULL);
		spinTg.addChild(shape);
		     		     
		objTrans.addChild(spinTg);
		
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData triangle = new TriangleData(root);
			triangle.setVerticies((Point3d[]) geom.triangles.get(i));
			triangles[i] = triangle;
		}		
		return objTrans;		
	}
	
	public void actionPerformed(ActionEvent e)
	{	
		
	    String value = e.getActionCommand();
	    if(value.equals("getPos"))
	    {
	    	boolean proceed = true;
	    	Double xPos = null;
	    	Double yPos = null;
	    	Double zPos = null;
	    	
	    	BranchGroup bg = new BranchGroup();
	    	bg.setCapability(bg.ALLOW_CHILDREN_WRITE);
	    	bg.setCapability(bg.ALLOW_CHILDREN_READ);
	    	
	    	try{	    		
		    	xPos = new Double(xarea.getText());
		    	yPos = new Double(yarea.getText());
		    	zPos = new Double(zarea.getText());
	    	}
	    	catch(Exception except)
	    	{
	    		JOptionPane.showMessageDialog(this, "Positions does not have correct number format");	    		
	    		proceed = false;
	    	}
	    	
		    if(proceed)
		    {
		    	for(int i = 0; i < triangleFaces; i++)
		    	{
		    		triangles[i].addSubunits(xPos.doubleValue(), yPos.doubleValue(), zPos.doubleValue(), bg, counter);
		    	}
		    	scene.addChild(bg);
		    	counter++;
		    	conSubts.updateCounter(counter);
		    }
	    }
	    else if(value.equals("writeToFile"))
	    {
	    	conSubts.writeToXML();
	    }
	    
	}
	private void setupGUI(JPanel panel) 
	{

		xarea = new JTextArea();
		yarea = new JTextArea();
		zarea = new JTextArea();
		
	    panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
	    panel.setBorder(new BevelBorder(BevelBorder.LOWERED));
	      
	    JButton addB = new JButton("Add");
	    panel.add(new JLabel("X pos = "));
	    panel.add(xarea);
	      
	    panel.add(new JLabel("Y pos = "));
	    panel.add(yarea);

	    panel.add(new JLabel("Z pos = "));
	    panel.add(zarea);

	    panel.add(addB);
	    addB.addActionListener(this);
	    addB.setActionCommand("getPos");
	      
	    JButton writeB = new JButton("WriteToFile");
	    panel.add(writeB);
	    writeB.addActionListener(this);
	    writeB.setActionCommand("writeToFile");
	}
	
	public void init()
	{		
		setLayout(new BorderLayout());
		Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		add("Center", c);

		JPanel guiPanel = new JPanel();
		setupGUI(guiPanel);
		add(guiPanel, BorderLayout.SOUTH);
		  
		scene = createSceneGraphic(c);

		SimpleUniverse u = new SimpleUniverse(c);
			

		conSubts = new ConnectSubunits(c, scene, triangles, triangleFaces, this);
		conSubts.setSchedulingBounds (bounds);
		scene.addChild (conSubts);
		
		u.getViewingPlatform().setNominalViewingTransform();
		View view = u.getViewer().getView();
		u.addBranchGraph(scene);
		 
		 
		OrbitBehavior orbit = new OrbitBehavior(c, OrbitBehavior.REVERSE_ALL);
		orbit.setSchedulingBounds(bounds);
		u.getViewingPlatform().setViewPlatformBehavior(orbit);
	}
		  
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		new MainFrame(new ToolTest(), 800, 800);
	}

}
