import java.util.*;
import javax.vecmath.*;

public class Subunit {

	private int subId;
	private Point3d subPos;
	private Vector bsts;
	private int counter = 0;
	private Subunit primarySubunit;
	private Subunit connectSubunit;
	
	public Subunit(int subId, Tuple3d pos)
	{
		subPos = new Point3d(pos);
		bsts = new Vector();
	}
	
	public int getSubId()
	{
		return subId;
	}
	public Point3d getPos()
	{
		return subPos;
	}
	
	public void setSubId(int id)
	{
		subId = id;
	}
	
	public void setPos(Tuple3d pos)
	{
		subPos = new Point3d(pos);
	}
	public void addBsts(BindingSiteType bst, int subtId)
	{
		bsts.add(bst);
		if(counter == 0)
			bst.setName("bst"+subtId+"a");
		else if(counter == 1)
			bst.setName("bst"+ subtId+"b");
		else if(counter == 2)
			bst.setName("bst" + subtId+"c");
		else if(counter == 3)
			bst.setName("bst" + subtId+"d");
		else if(counter == 4)
			bst.setName("bst" + subtId+"e");
		else if(counter == 5)
			bst.setName("bst" + subtId+"f");
		else if(counter == 6)
			bst.setName("bst" + subtId+"g");
		else if(counter == 7)
			bst.setName("bst" + subtId+"h");

		else
		{
			System.out.println("Currently there can be upto 3 binding site types");
			System.exit(-1);
		}
		bst.setPrimaryReference(primarySubunit);
		bst.setConnectReference(connectSubunit);
		counter++;
	}
	
	public void setPrimaryReference(Subunit prim)
	{
		primarySubunit = prim;
	}
	
	public void setConnectReference(Subunit connect)
	{
		connectSubunit = connect;
	}
	
	/*
	public Subunit getPrimaryReference()
	{
		return primarySubunit;
	}
	
	public Subunit getConnectReferece()
	{
		return connectSubunit;
	}
	*/
	public BindingSiteType getBindingSiteType(int bstId)
	{
		return (BindingSiteType) bsts.get(bstId);
	}

	public int getBindingSiteCounter()
	{
		return counter;
	}
}
