
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.io.*;

import com.sun.j3d.utils.picking.*;

import javax.media.j3d.*;
import javax.swing.JFileChooser;
import javax.vecmath.*;


public class ConnectSubunits extends Behavior
{
	private PickCanvas pickCanvas;
	private PickResult[] pickResult;
	private TriangleData[] triangles;
	private int triangleFaces;
	private int numberDifferentSubt;
	private boolean primary = true;
	private Point3d primaryPos;
	private Point3d connectPos;
	private BranchGroup scene;
	private ToolTest tool;
	
	public ConnectSubunits(Canvas3D canvas, BranchGroup bg, TriangleData[] tri, int faces, ToolTest myTool)
	{		
		pickCanvas = new PickCanvas(canvas, bg);
	    pickCanvas.setTolerance(5.0f);
	    triangles = tri;
	    triangleFaces = faces;
	    scene = bg;
	    tool = myTool;
	    
	}

	public void updateCounter(int counter)
	{
		numberDifferentSubt = counter;
	}
	
	public void initialize()
	{
		wakeupOn (new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED));
	}
	
	public void processStimulus (Enumeration criteria) 
	{
	    WakeupCriterion wakeup;
	    AWTEvent[] event;
	    int eventId;
		
	    while (criteria.hasMoreElements()) 
	    {
	      wakeup = (WakeupCriterion) criteria.nextElement();
	      if (wakeup instanceof WakeupOnAWTEvent) 
	      {
	    	  event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
	    	  for (int i=0; i<event.length; i++) 
	    	  { 
	    		  eventId = event[i].getID();
	    		  if (eventId == MouseEvent.MOUSE_PRESSED) 
	    		  {
	    			  int x = ((MouseEvent)event[i]).getX();
	    			  int y = ((MouseEvent)event[i]).getY();

	    			  pickCanvas.setShapeLocation(x, y);
	    			  Point3d eyePos = pickCanvas.getStartPosition ();
	    			  pickResult = pickCanvas.pickAllSorted();
	    			  
	    			  if (pickResult != null) 
	    			  {
	    				  // Get closest intersection results
	    				  PickIntersection pi = pickResult[0].getClosestIntersection(eyePos);
	    				  Vector3d v = new Vector3d();
	    				  Point3d closestVert = pi.getClosestVertexCoordinatesVW();
	    				  v.set(closestVert);
	    				  
	    				  if(primary)
	    				  {
	    					  primaryPos = closestVert;
	    					  primary = false;
	    				  }
	    				  else
	    				  {
	    					  connectPos = closestVert;
	    					  System.out.println(primaryPos);
	    					  System.out.println(connectPos);
	    					  bindSubunits(primaryPos, connectPos);
	    					  primary = true;
	    				  }
	    			  }
	    		  }
	    	  }
	      }
	    }
	    
	    wakeupOn (new WakeupOnAWTEvent(MouseEvent.MOUSE_PRESSED));
	}
	
	private void bindSubunits(Point3d primarySubPos, Point3d connectSubPos)
	{
		boolean primaryFound = false;
		boolean connectingFound = false;
		int primTriId = -1;
		int connectTriId = -1;
		int primSubtId = -1;
		int connectSubtId = -1;
		int primSubId = -1;
		int connectSubId = -1;
		Subunit primSub = null;
		Subunit connectSub = null;
		
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData tData = triangles[i];
			for(int j = 0; j < numberDifferentSubt; j++)
			{
				SubunitType subt = tData.getSubt(j);
				for(int k = 0; k < 3; k++)
				{
					Subunit sub = subt.getSub(k);
					if(sub.getPos().epsilonEquals(primarySubPos, 0.05))
					{
						
						primTriId = i;
						primSubtId = j;
						primSubId = k;
						
						primSub = sub;
						primaryFound = true;
					}
					else if(sub.getPos().epsilonEquals(connectSubPos, 0.05))
					{
						
						connectTriId = i;
						connectSubtId = j;
						connectSubId = k;
						
						connectSub = sub;
						connectingFound = true;

					}
					
					if(primaryFound && connectingFound)
					{
				//		storeReference(primSub, connectSub, primSubtId, connectSubtId);
						//setBindingSiteTypes(primTriId, connectTriId, primSubtId, connectSubtId,
						//		primSubId, connectSubId, primarySubPos, connectSubPos);
						setBindingSiteTypes(primTriId, connectTriId, primSubtId, connectSubtId,
								primSubId, connectSubId, primSub.getPos(), connectSub.getPos());

						return;
					}
				}
			}
		}
	}
	
	public void setBindingSiteTypes(int primTriIndex, int connectTriIndex, int primSubtindex, 
			int connectSubtindex, int primSubindex,  int connectSubindex, 
			Point3d primSubPos, Point3d connectSubPos)
	{

		Vector3d bVec = new Vector3d(primSubPos);
		bVec.sub(connectSubPos);
		
		double bindLength = bVec.length();
		
		if(primTriIndex != connectTriIndex)
		{
			if(primSubtindex == connectSubtindex)
			{
				Point3d midPoint = new Point3d(primSubPos);
				midPoint.add(connectSubPos);			
				midPoint.scale(0.5);
				boolean fiveFold = true;
				TriangleData tri = triangles[primTriIndex];
				for(int i = 0; i < 3; i++)
				{
					Vector3d twoFoldAxis = tri.getTwoFoldAxis(i);
				
					if(midPoint.epsilonEquals(twoFoldAxis, 0.1))
					{
						connectByTwoFold(primSubtindex, primSubPos, connectSubPos, bindLength);
						fiveFold = false;
						break;
					}
				}
				if(fiveFold)
				{
					System.out.println("five fold");
					connectByFiveFold(primSubtindex, connectSubtindex, primSubindex, connectSubindex, bindLength);
				}
			}
			else
			{
				System.out.println("five fold");
				connectByFiveFold(primSubtindex, connectSubtindex, primSubindex, connectSubindex, bindLength);
			}
		}
		else
		{
			System.out.println("three fold");
			connectByThreeFold(primTriIndex, primSubtindex, connectSubtindex, primSubindex, connectSubindex, bindLength);
		}
			
	}
	
	public void connectByFiveFold(int primSubtindex, int connectSubtindex, 
			int primSubindex, int connectSubindex, double bLength)
	{
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData tdata = triangles[i];
			SubunitType subt = tdata.getSubt(primSubtindex);
			for(int j = 0; j < 3; j++)
			{
				
				Subunit sub = subt.getSub(j);
				Vector3d vec;
				double length = 100000;
				int pointId = -1;
				
				for(int k = 0; k < 3; k++)
				{
					vec= new Vector3d(sub.getPos());
					vec.sub(tdata.getVertex(k));
					double tempLength = vec.length();
					if(tempLength < length)
					{
						length = tempLength;
						pointId = k;
					}					
				}
				
				if(primSubtindex == connectSubtindex)
				{					
					Vector3d fiveFoldAxis = new Vector3d(tdata.getVertex(pointId));
					vec = new Vector3d(sub.getPos());
					AxisAngle4d rotAxis = new AxisAngle4d(fiveFoldAxis, Math.PI * (72.0/180.0));
					vec = rotateByAxis(vec, rotAxis);
					BindingSiteType bst = new BindingSiteType();
					Vector3d primbsPos = new Vector3d(vec);
					primbsPos.sub(sub.getPos());
					bst.setPos(primbsPos);
					
					Vector3d otherVec = new Vector3d(sub.getPos());
					rotAxis = new AxisAngle4d(fiveFoldAxis, Math.PI * (-72.0/180.0));
	
					otherVec = rotateByAxis(otherVec, rotAxis);
					BindingSiteType otherBst = new BindingSiteType();
					Vector3d connectbsPos = new Vector3d(otherVec);
					connectbsPos.sub(sub.getPos());
					otherBst.setPos(connectbsPos);
					
					sub.addBsts(bst, primSubtindex);
					sub.addBsts(otherBst, connectSubtindex);
					
					bst.setPartnerName(otherBst.getName());
					otherBst.setPartnerName(bst.getName());
					
					bst.setLength(bLength);
					otherBst.setLength(bLength);
					
					
					LineArray la = new LineArray(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3);
					Point3d[] lines = new Point3d[4];
					Color3f[] colors = new Color3f[4];
					
					lines[0] = sub.getPos();
					lines[1] = new Point3d(vec);
					
					lines[2] = sub.getPos();
					lines[3] = new Point3d(otherVec);
					
					colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[1] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[2] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[3] = new Color3f(1.0f, 0.0f, 0.0f);
					
					la.setCoordinates(0, lines);
					la.setColors(0, colors);
										
					Shape3D shape = new Shape3D(la);
					shape.setPickable(false);
					BranchGroup bg = new BranchGroup();
					bg.addChild(shape);
					scene.addChild(bg);
				}				
				else
				{
					for(int k = 0; k < triangleFaces; k++)
					{
						boolean found = false;
						if(k != i)
						{
							TriangleData connectTri = triangles[k];
							SubunitType connectSubt = connectTri.getSubt(connectSubtindex);
							for(int l = 0; l < 3; l++)
							{
								Subunit connectSub = connectSubt.getSub(l);
								Vector3d lengthVec = new Vector3d(connectSub.getPos());
								lengthVec.sub(sub.getPos());
								if(Math.abs(lengthVec.length() - bLength) < 0.0001)
								{
									BindingSiteType primBst = new BindingSiteType();
									primBst.setPos(lengthVec);
									
									Vector3d otherVec = new Vector3d(lengthVec);
									otherVec.scale(-1.0);
									
									BindingSiteType connectBst = new BindingSiteType();
									connectBst.setPos(otherVec);
									
									sub.addBsts(primBst, primSubtindex);
									connectSub.addBsts(connectBst, connectSubtindex);
									
									primBst.setPartnerName(connectBst.getName());
									connectBst.setPartnerName(primBst.getName());
									
									primBst.setLength(bLength);
									connectBst.setLength(bLength);
									found = true;
									
									LineArray la = new LineArray(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3);
									Point3d[] lines = new Point3d[4];
									Color3f[] colors = new Color3f[4];
									
									lines[0] = sub.getPos();
									lines[1] = new Point3d(connectSub.getPos());
									
									lines[2] = connectSub.getPos();
									lines[3] = new Point3d(sub.getPos());
									
									colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
									colors[1] = new Color3f(1.0f, 0.0f, 0.0f);
									colors[2] = new Color3f(1.0f, 0.0f, 0.0f);
									colors[3] = new Color3f(1.0f, 0.0f, 0.0f);
									
									la.setCoordinates(0, lines);
									la.setColors(0, colors);
														
									Shape3D shape = new Shape3D(la);
									shape.setPickable(false);
									BranchGroup bg = new BranchGroup();
									bg.addChild(shape);
									scene.addChild(bg);
									
								}
								
							}
						}
						if(found)
							break;
					}
					/*
					System.out.println("It is not implemented yet!!!!");
					System.out.println("prim subt = " + primSubtindex + " connect subt = " + connectSubtindex);
				//	System.exit(-1);
				 */
				 
				}
			}
		}
	}
	public void connectByTwoFold(int primSubt, Point3d subPos1, Point3d subPos2, double bLength)
	{
		
		Vector3d tempLength = new Vector3d(subPos1);
		tempLength.sub(subPos2);
		double length = tempLength.length();
		
		
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData primTri = triangles[i];
			
			for(int j = 0; j < triangleFaces; j++)
			{
				TriangleData connectTri = triangles[j];
				if(i != j)
				{
					for(int k = 0; k < 3; k++)
					{
						Subunit primSub = primTri.getSubt(primSubt).getSub(k);
						boolean isTwoFold = false;
						for(int l = 0; l < 3; l++)
						{
							Subunit connectSub = connectTri.getSubt(primSubt).getSub(l);
							Point3d primSubPos = primSub.getPos();
							Point3d connectSubPos = connectSub.getPos();
							
							Vector3d midPoint = new Vector3d(primSubPos);
							midPoint.add(connectSubPos);
							
							midPoint.scale(0.5);
							
							for(int m = 0; m < 3; m++)
							{
								Vector3d twoFold = primTri.getTwoFoldAxis(m);
								Vector3d check = new Vector3d(connectSub.getPos());
								check.sub(primSub.getPos());
								

								if(twoFold.epsilonEquals(midPoint, 0.1)  && ( Math.abs(length - check.length()) < 0.001))
								{
									isTwoFold = true;
									
									BindingSiteType bst = new BindingSiteType();
									Vector3d bstPos = new Vector3d(connectSub.getPos());
									bstPos.sub(primSub.getPos());
									
									bst.setPos(bstPos);
									primSub.addBsts(bst, primSubt);
									bst.setPartnerName(bst.getName());
									bst.setLength(bLength);
									
									break;
								}
							}
							
							if(isTwoFold)
							{
								LineArray la = new LineArray(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3);
								Point3d[] lines = new Point3d[4];
								Color3f[] colors = new Color3f[4];
								
								lines[0] = primSub.getPos();
								lines[1] = connectSub.getPos();
								
								lines[2] = connectSub.getPos();
								lines[3] = primSub.getPos();
								
								colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
								colors[1] = new Color3f(1.0f, 0.0f, 0.0f);
								colors[2] = new Color3f(1.0f, 0.0f, 0.0f);
								colors[3] = new Color3f(1.0f, 0.0f, 0.0f);
								
								la.setCoordinates(0, lines);
								la.setColors(0, colors);
								
								
								
								Shape3D shape = new Shape3D(la);
								shape.setPickable(false);
								BranchGroup bg = new BranchGroup();
								bg.addChild(shape);
								scene.addChild(bg);
								
								break;
							}
								
						}
					}
				}
			}
		}
	}
	
	public void connectByThreeFold(int triIndex, int primSubtIndex, int connectSubtIndex,
			int primSubIndex, int connectSubIndex, double bLength)
	{
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData tData = triangles[i];
			if(primSubtIndex == connectSubtIndex)
			{
				SubunitType subt = tData.getSubt(primSubtIndex);
				for(int j = 0; j < 3; j++)
				{
					
					Subunit sub = subt.getSub(j);
					Vector3d vec;
					
					Vector3d fiveFoldAxis = new Vector3d(tData.getCenterPoint());
					vec = new Vector3d(sub.getPos());
					AxisAngle4d rotAxis = new AxisAngle4d(fiveFoldAxis, Math.PI * (120.0/180.0));
					vec = rotateByAxis(vec, rotAxis);
					BindingSiteType bst = new BindingSiteType();
					Vector3d primbsPos = new Vector3d(vec);
					primbsPos.sub(sub.getPos());
					bst.setPos(primbsPos);
						
					Vector3d otherVec = new Vector3d(sub.getPos());
					rotAxis = new AxisAngle4d(fiveFoldAxis, Math.PI * (-120.0/180.0));
		
					otherVec = rotateByAxis(otherVec, rotAxis);
					BindingSiteType otherBst = new BindingSiteType();
					Vector3d connectbsPos = new Vector3d(otherVec);
					connectbsPos.sub(sub.getPos());
					otherBst.setPos(connectbsPos);
						
					System.out.println("CHECK!!!!!!!!!!!!!!!!!!");
					System.out.println(primbsPos.angle(connectbsPos) * 180.0/Math.PI);

					sub.addBsts(bst, primSubtIndex);
					sub.addBsts(otherBst, connectSubtIndex);
						
					bst.setPartnerName(otherBst.getName());
					otherBst.setPartnerName(bst.getName());
						
					bst.setLength(bLength);
					otherBst.setLength(bLength);
					
					
					LineArray la = new LineArray(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3);
					Point3d[] lines = new Point3d[4];
					Color3f[] colors = new Color3f[4];
					
					lines[0] = sub.getPos();
					lines[1] = new Point3d(vec);
					
					lines[2] = sub.getPos();
					lines[3] = new Point3d(otherVec);
					
					colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[1] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[2] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[3] = new Color3f(1.0f, 0.0f, 0.0f);
					
					la.setCoordinates(0, lines);
					la.setColors(0, colors);
										
					Shape3D shape = new Shape3D(la);
					shape.setPickable(false);
					BranchGroup bg = new BranchGroup();
					bg.addChild(shape);
					scene.addChild(bg);
				}
					/*
					for(int k = j+1; k < 3; k++)
					{
						if(k != j)
						{
							Subunit connectSub = subt.getSub(k);
							Vector3d bsPos = new Vector3d(connectSub.getPos());							
							bsPos.sub(primSub.getPos());
							
							Vector3d connectBsPos = new Vector3d(bsPos);
							connectBsPos.scale(-1.0);

							BindingSiteType bType = new BindingSiteType();
							bType.setPos(bsPos);
							
							BindingSiteType cBType = new BindingSiteType();
							cBType.setPos(connectBsPos);
							
							primSub.addBsts(bType, primSubtIndex);
							connectSub.addBsts(cBType, connectSubtIndex);
							
							bType.setPartnerName(cBType.getName());
							cBType.setPartnerName(bType.getName());
							
							bType.setLength(bLength);
							cBType.setLength(bLength);
						
							LineArray la = new LineArray(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3);
							Point3d[] lines = new Point3d[4];
							Color3f[] colors = new Color3f[4];
							
							lines[0] = primSub.getPos();
							lines[1] = connectSub.getPos();
							
							lines[2] = connectSub.getPos();
							lines[3] = primSub.getPos();
							
							colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
							colors[1] = new Color3f(1.0f, 0.0f, 0.0f);
							colors[2] = new Color3f(1.0f, 0.0f, 0.0f);
							colors[3] = new Color3f(1.0f, 0.0f, 0.0f);
							
							la.setCoordinates(0, lines);
							la.setColors(0, colors);
							
							
							
							Shape3D shape = new Shape3D(la);
							shape.setPickable(false);
							BranchGroup bg = new BranchGroup();
							bg.addChild(shape);
							scene.addChild(bg);
						}	
						
					}
					
				}
				*/
			}
			else
			{					
				SubunitType primSubt = tData.getSubt(primSubtIndex);
				SubunitType connectSubt = tData.getSubt(connectSubtIndex);

				for(int j = 0; j < 3; j++)
				{
					int primSubNum = (primSubIndex + j) % 3;
					int connectSubNum = (connectSubIndex + j) % 3;
					
					Subunit primSub = primSubt.getSub(primSubNum);
					Subunit connectSub = connectSubt.getSub(connectSubNum);
				
					Vector3d primBsPos = new Vector3d(connectSub.getPos());
					primBsPos.sub(primSub.getPos());
				
					Vector3d connectBsPos = new Vector3d(primSub.getPos());
					connectBsPos.sub(connectSub.getPos());
					
					BindingSiteType primBsType = new BindingSiteType();
					primBsType.setPos(primBsPos);
					
					
					BindingSiteType connectBsType = new BindingSiteType();
					connectBsType.setPos(connectBsPos);

					primSub.addBsts(primBsType, primSubtIndex);					
					connectSub.addBsts(connectBsType, connectSubtIndex);				

					primBsType.setPartnerName(connectBsType.getName());
					connectBsType.setPartnerName(primBsType.getName());
					
					primBsType.setLength(bLength);
					connectBsType.setLength(bLength);
					
					
					LineArray la = new LineArray(4, GeometryArray.COORDINATES | GeometryArray.COLOR_3);
					Point3d[] lines = new Point3d[4];
					Color3f[] colors = new Color3f[4];
					
					lines[0] = primSub.getPos();
					lines[1] = new Point3d(connectSub.getPos());
					lines[2] = connectSub.getPos();
					lines[3] = new Point3d(primSub.getPos());
					
					colors[0] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[1] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[2] = new Color3f(1.0f, 0.0f, 0.0f);
					colors[3] = new Color3f(1.0f, 0.0f, 0.0f);
					
					la.setCoordinates(0, lines);
					la.setColors(0, colors);
					
					
					  
					Shape3D shape = new Shape3D(la);
					shape.setPickable(false);
					BranchGroup bg = new BranchGroup();
					bg.addChild(shape);
					scene.addChild(bg);
			}
		}
	}
	}
/*
	private void storeReference(Subunit primarySub, Subunit connectSub, int primarySubtindex, int connectSubtindex)
	{
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData tData = triangles[i];
			
			SubunitType primarySubt = tData.getSubt(primarySubtindex);
			SubunitType connectSubt = tData.getSubt(connectSubtindex);
			
			for(int j = 0; j < 3; j++)
			{
				primarySubt.getSub(j).setPrimaryReference(primarySub);
				primarySubt.getSub(j).setConnectReference(connectSub);
				
				connectSubt.getSub(j).setPrimaryReference(connectSub);
				connectSubt.getSub(j).setConnectReference(primarySub);
			}
			
			
		}
	}
	*/
	public void writeAssembly(FileWriter fw)
	{
		TriangleData tData = triangles[0];
		try
		{
			for(int i = 0; i < tData.getMaxSubts(); i++)
			{
				SubunitType subt = tData.getSubt(i);
				
				if(subt == null)
					break;
				
				Subunit sub = subt.getSub(0);
				fw.write("\t<Assembly name=\"assem\" k=\" \" amount=\"100\" type=\"monomer\">\n");				
				fw.write("\t\t<Subunit name=\"" + i +"\" domain=\"0\" type=\"only" + i +"\">\n");
				
				fw.write("\t\t\t<Position x=\"0.0\" y=\"0.0\" z=\"0.0\"/>\n");
				fw.write("\t\t\t<Rotation x=\"0.0\" y=\"0.0\" z=\"0.0\" w=\"1.0\"/>\n");
				fw.write("\t\t\t<Velocity x=\"0.0\" y=\"0.0\" z=\"0.0\"/>\n");
				fw.write("\t\t\t<Rotational_Velocity x=\"0.0\" y=\"0.0\" z=\"0.0\" w=\"1.0\"/>\n");
				
				fw.write("\t\t</Subunit>\n");
					
				fw.write("\t</Assembly>\n");
			}
		}
		catch(Exception e)
		{
			System.out.println(e);
		}
	}
	
	public void writeBindingInteract(FileWriter fw)
	{
		TriangleData tData = triangles[0];
		try
		{
			fw.write("\t<BindingInteract>\n");
			for(int i = 0; i < tData.getMaxSubts(); i++)
			{
				SubunitType subt = tData.getSubt(i);
				if(subt == null)
					break;
				Subunit sub = subt.getSub(0);
				
				for(int j = 0; j < sub.getBindingSiteCounter(); j++)
				{
					BindingSiteType bst = sub.getBindingSiteType(j);
					fw.write("\t\t<BindBreak name=\"" + bst.getName()+"\">\n");
					fw.write("\t\t\t<Time name=\"" +bst.getPartnerName()
							+"\" bindTime=\"1\" breakTime=\"1\" " +
									"fastbindTime=\"0.00000000001\"/>\n");
					fw.write("\t\t</BindBreak>\n");
				}
			}
			fw.write("\t</BindingInteract>\n");
			fw.flush();
		}catch(Exception e)
		{
			System.out.println(e);
		}
	}
	public void writeBindingSiteTypes(FileWriter fw)
	{
		TriangleData tData = triangles[0];
		try
		{
			fw.write("\t<BindingSiteTypes>\n");		
			for(int i = 0; i < tData.getMaxSubts(); i++)
			{
				SubunitType subt = tData.getSubt(i);
		
				if(subt == null)
					break;
		
				Subunit sub = subt.getSub(0);
				Vector3d primaryUp = new Vector3d(1.0, 1.0, 1.0);
			
				for(int j = 0; j < sub.getBindingSiteCounter(); j++)
				{
					BindingSiteType bst = sub.getBindingSiteType(j);
					//primaryUp = new Vector3d(sub.getPos());
					Vector3d connectUp = new Vector3d(primaryUp);
					//connectUp.add(bst.getPos());
					Vector3d bindingVector = new Vector3d(bst.getPos());
					Vector3d connectBind = new Vector3d(bindingVector);
					connectBind.scale(-1.0);
				
					Vector3d primProjVec = makePerpendicular(bindingVector, primaryUp);
					Vector3d connectProjVec = makePerpendicular(connectBind, connectUp);
					Vector3d checkClockwise = new Vector3d();
					checkClockwise.cross(primProjVec, connectProjVec);
			
					double angle = -2000000;
					if(Math.abs(checkClockwise.angle(bindingVector) - Math.PI) < 0.0001)
					{
						angle = -primProjVec.angle(connectProjVec);
					}
					else
					{
						angle = primProjVec.angle(connectProjVec);
					}
				
				
					fw.write("\t\t<BindingSiteType name=\"" + bst.getName()+"\">\n");
					fw.write("\t\t\t<tolerance transition=\"0.2\" torsion=\"0.1\" bending=\"0.1\"/>\n");
					fw.write("\t\t\t<partner name=\"" + bst.getPartnerName() + "\" angle=\"" + angle+"\"/>\n");
					fw.write("\t\t</BindingSiteType>\n");
								
					System.out.println("bst = " + bst.getName() + " partner = " + bst.getPartnerName());
					System.out.println(angle);								
				}
			}
			fw.write("\t</BindingSiteTypes>\n");
		}catch(Exception e)
		{
			System.out.println(e);
		}		
	}
	public void writeSubunitType(FileWriter fw)
	{
		TriangleData tData = triangles[0];
		try
		{
			for(int i = 0; i < tData.getMaxSubts(); i++)
			{
				SubunitType subt = tData.getSubt(i);
				
				if(subt == null)
					break;
			
				Subunit sub = subt.getSub(0);

				fw.write("\t<SubunitType name=\"only" + i +"\" id=\"0\"> \n");
				fw.write("\t<Up x=\"" + sub.getPos().x+
						"\" y=\"" + sub.getPos().y +
						"\" z=\"" + sub.getPos().z + "\"/> \n");
			  
				fw.write("\t\t<Domain position=\"\" id=\"0\" currentConf=\"bs\">\n");
				fw.write("\t\t\t<Conformation name=\"bs\" Evalue=\"6.6\">\n");
		  
				for(int j = 0; j < sub.getBindingSiteCounter(); j++)
				{
					fw.write("\t\t\t\t<BindingSite name=\"");
					fw.write(sub.getBindingSiteType(j).getName());

					fw.write("\" type=\"");
					fw.write(sub.getBindingSiteType(j).getName());
					fw.write("\">\n");
				  
					Vector3d bPos = sub.getBindingSiteType(j).getPos();
					bPos.normalize();
					bPos.scale(sub.getBindingSiteType(j).getLength());
					fw.write("\t\t\t\t\t<Bpos x=\"" + bPos.x);

					fw.write("\" y=\"" + bPos.y);
					fw.write("\" z=\"" + bPos.z);
					fw.write("\"/>\n");
				  

					Vector3d ors = new Vector3d(0,1,0);
					ors.cross(ors, sub.getBindingSiteType(j).getPos());
					double angle = sub.getBindingSiteType(j).getPos().angle(new Vector3d(0,1,0));
				  
					AxisAngle4d rotAxis = new AxisAngle4d(ors, angle);
				  
					fw.write("\t\t\t\t\t<Orientation x=\"" + rotAxis.x);
					fw.write(" \" y=\"" + rotAxis.y);
					fw.write(" \" z=\"" + rotAxis.z);
					fw.write(" \" w=\"" + rotAxis.angle); 			
					fw.write("\"/>\n");
					fw.write("\t\t\t\t</BindingSite>\n");
				}
			
				fw.write("\t\t\t</Conformation>\n");
				fw.write("\t\t</Domain>\n");
				fw.write("\t</SubunitType>\n");
				fw.flush();		  
			}
		}
		catch (Exception e)
		{
			System.out.println(e);
		}		
	}
	
	public void writeToXML()
	{		
		TriangleData tData = triangles[0];
		
    	File f = new File("./");
    	JFileChooser jFile = new JFileChooser(f);
    	jFile.setDialogType(JFileChooser.SAVE_DIALOG);
    	jFile.showSaveDialog(tool);
    	
    	if(jFile.getSelectedFile() != null)
    	{
    		try
    		{
    			FileWriter fw = new FileWriter(jFile.getSelectedFile().getPath());
    			fw.write("<System type=\"virus\">\n");
    			fw.write("\t<Solution Temp=\"50\" pH=\"7\" Volume=\"200\"/>\n");
			
    			writeAssembly(fw);
    			writeBindingInteract(fw);
    			writeBindingSiteTypes(fw);
    			writeSubunitType(fw);
			
    			fw.write("</System>");
    			fw.flush();
    		}
    		catch(Exception e)
    		{
    			System.out.println(e);
    		}
    	}
	}
	
	private Vector3d makePerpendicular(Vector3d v1, Vector3d v2)
	{
		double angle = v1.angle(v2);
		AxisAngle4d rot;
		if(angle == Math.PI/2)
		{
			return new Vector3d(v2);
		}
		else
		{
			Vector3d tempAxis = new Vector3d();
			tempAxis.cross(v1, v2);
			rot = new AxisAngle4d(tempAxis, Math.PI/2 - angle);
		}
				
		Vector3d temp = rotateByAxis(v2, rot);
		return temp;
	}
	
	private Vector3d rotateByAxis(Vector3d v, AxisAngle4d a) 
	{
		Matrix4d m=new Matrix4d();
	    m.set(a);
	    Vector3d rv=new Vector3d();
	    m.transform(v,rv);
	    return rv;
	}
}
