
import java.util.Vector;
import java.util.HashMap;
import java.util.Random;
import java.util.Iterator;

/**
 * holds proporties of the solution that may become relevant in a later version
 * @author Rori Rohlfs
 * @version 1.0	
 * 
 */


public class Solution {

    /**
     * properties is a HashMap associating property names (Strings) with values (Doubles)
     */
    private HashMap properties = new HashMap();    

    /**
     * inner class, This provides a properity name and its value
     */
    
    private class prop {
        
    private	String name;

    private double value;

        prop(String n, double v) {
            name = n;
            value = v;
        }

        public String getName() {
            return name;
        }

        public double getVal() {
            return value;
        }
    }

    /**
     * Constructs a default Solution with the default properties: 
     * temp: 300.0,
     * pH: 7.0, 
     * volume:100.0
     */
    public Solution() {
        properties.put("temp", new Double(300.0));
	properties.put("pH", new Double(7.0));
 	properties.put("volume", new Double(100.0));
    }

    /**
     * Constructs a Solution with specified temperature, pH and volume
     * 
     * @param t		Temperature
     * @param p		pH
     * @param v		Volume
     *            
     */
    public Solution(double t, double p, double v) {
	properties.put("temp", new Double(t));
	properties.put("pH", new Double(p));
 	properties.put("volume", new Double(v));
    }

    /**
     * Constructs a Solution from a vector of property names and a vector of
     * corresponding property values.
     * 
     * @param n		Vector of property names (must be Vector of Strings)
     * @param v		Vector of property values (must be Vector of Doubles)
     */
    public Solution(Vector n, Vector v) {
        for (int i=0; i<n.size(); i++) 
            properties.put(n.get(i), v.get(i));
    }

    /**
     * Gets the property requested by parameter
     * 
     * @param p		The property requested
     * @return 		The value of the property requested or -1.0
     */
    public double getProperty(String p) {
	return ((Double) properties.get(p)).doubleValue();
    }

    /**
     * Sets the specified property to the specified value in the Vector of
     * props. If this property does not yet exist, it is added to the Vector.
     * 
     * @param n		Property
     * @param v		Value of the property to set to
     *            
     */
    public void setProperty(String n, double v) {
	properties.put(n, new Double(v));
    }

    /**
     * Returns a String version of this Solution
     * 
     * @return String
     */
    public String toString() {
        String mystring = new String("Solution Properties:");

	Iterator it = properties.keySet().iterator();
	while(it.hasNext()) {
            String n = (String) it.next();
	    mystring += "\n\t" + n + ": " + (Double) properties.get(n);
        }

        return mystring;
    }
}