
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.*;

/**
 * @author Sue Yi Chew
 * @version 1.0
 * 
 * TODO update in the future
 *  
 */
public class NewSimulationDialog extends JDialog implements ActionListener,
        ListSelectionListener, PropertyChangeListener {
    /*
     * at the moment ListSelectionListener is not used. Its here in case want to
     * add some action that responds to list selection
     */

    private JOptionPane optionPane;

    private Object[] options; //final button -- ready

    private JPanel solPanel; //panel for solution

    /** start -- for solDisplayPanel* */
    private JPanel solDisplayPanel;

    private DefaultListModel sListModel;

    private JList sList;

    /** end -- for solDisplayPanel* */

    /** start -- for addPropPanel* */
    private JPanel addPropPanel;

    private JTextField propName;

    private JTextField propValue;

    /** end -- for addPropPanel* */

    /**
     * Constructs NewSimulationDialog
     * 
     * @param aFrame
     *            MainFrame object is used.
     */
    public NewSimulationDialog(Frame aFrame) {
        super(aFrame, true);

        setSize(600, 200);

        initFrame();
    }

    private void initFrame() {

        /**
         * ************************start -- Setting up
         * solPanel************************
         */
        solPanel = new JPanel();
        solPanel
                .setBorder(BorderFactory
                        .createTitledBorder("Initializing solution for this simulation"));
        solPanel.setLayout(new BorderLayout());

        initSolDisplayPanel();
        initAddPropPanel();

        //adding the components
        solPanel.add(solDisplayPanel, BorderLayout.WEST);
        solPanel.add(addPropPanel, BorderLayout.EAST);

        /**
         * ************************end -- Setting up
         * solPanel************************
         */

        //Create an array specifying the number of dialog buttons and their
        // text.
        options = new Object[1];
        options[0] = "DONE";

        //Create the JOptionPane.
        optionPane = new JOptionPane(solPanel, JOptionPane.QUESTION_MESSAGE,
                JOptionPane.YES_OPTION, null, options);

        //Make this dialog display it.
        setContentPane(optionPane);

        //Handle window closing correctly.
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                /*
                 * Instead of directly closing the window, we're going to change
                 * the JOptionPane's value property.
                 */
                optionPane.setValue(new Integer(JOptionPane.CLOSED_OPTION));
            }
        });

        //Register an event handler that reacts to option pane state changes.
        optionPane.addPropertyChangeListener(this);

    }

    private void initSolDisplayPanel() {
        //setting up panel
        solDisplayPanel = new JPanel();
        solDisplayPanel.setLayout(new BoxLayout(solDisplayPanel,
                BoxLayout.Y_AXIS));

        //label
        JLabel label = new JLabel("Solution properties:");

        //Create the list and put it in a scroll pane.
        sListModel = new DefaultListModel();
        //sListModel.addElement("bla"); -- if any properties are to be added by
        // default
        sList = new JList(sListModel);
        sList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        //sList.setSelectedIndex(0);
        sList.addListSelectionListener(this);
        sList.setVisibleRowCount(4);
        JScrollPane sListScrollPane = new JScrollPane(sList);

        //adding the components to the panel
        solDisplayPanel.add(label);
        solDisplayPanel.add(sListScrollPane);

    }

    private void initAddPropPanel() {
        //setting up panel
        addPropPanel = new JPanel();
        addPropPanel.setBorder(BorderFactory
                .createTitledBorder("Add new Property"));
        addPropPanel.setLayout(new BorderLayout());

        //textfields
        propName = new JTextField(10);
        propValue = new JTextField(10);

        //buttons
        JButton clear = new JButton("Clear");
        clear.addActionListener(this);
        clear.setActionCommand("clear");

        JButton add = new JButton("Add");
        add.addActionListener(this);
        add.setActionCommand("add");

        //adding the components to the panel. The grid JPanel is just for
        // layout
        JPanel grid = new JPanel(new GridLayout(2, 2));
        grid.add(new JLabel("Property name:"));
        grid.add(propName);
        grid.add(new JLabel("Property value:"));
        grid.add(propValue);

        addPropPanel.add(grid, BorderLayout.NORTH);
        addPropPanel.add(clear, BorderLayout.WEST);
        addPropPanel.add(add, BorderLayout.EAST);

    }

    public void actionPerformed(ActionEvent e) {

        if (e.getActionCommand().equals("clear")) {
            propName.setText("");
            propValue.setText("");
        } else if (e.getActionCommand().equals("add")) {
            sListModel.addElement(propName.getText() + " ("
                    + propValue.getText() + ")");
        }

    }

    //This method is required by ListSelectionListener.
    public void valueChanged(ListSelectionEvent e) {

    }

    /** This method clears the dialog and hides it. */
    public void clearAndHide() {
        setVisible(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();

        if (isVisible()
                && (e.getSource() == optionPane)
                && (JOptionPane.VALUE_PROPERTY.equals(prop) || JOptionPane.INPUT_VALUE_PROPERTY
                        .equals(prop))) {
            Object value = optionPane.getValue();

            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                //ignore reset
                return;
            }

            //Reset the JOptionPane's value.
            //If you don't do this, then if the user
            //presses the same button next time, no
            //property change event will be fired.
            optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);

            clearAndHide();
        }

    }

}

