
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.beans.*; //property change stuff

/**
 * @author Sue Yi Chew
 * @version 1.0
 * 
 * TODO update in the future
 *  
 */
public class NewAssemblyDialog extends JDialog implements ActionListener,
        ListSelectionListener, PropertyChangeListener {

    private int numSubunits; //# of subunits in this assembly

    private JOptionPane optionPane;

    private JPanel mainPanel; //main panel with New Assembly label

    private Object[] options; //final button -- ready to add Assembly to
                              // simulation

    /** start -- for subunitPanel* */
    private JPanel subunitPanel; //panel for subunit details

    private JLabel numSubunitsLabel; //label which displays numSubunits

    private DefaultListModel sListModel;

    private JList sList;

    private JButton addNewSubunitB;

    private JButton displaySubunitDetailsB;

    private NewSubunitDialog newsubunitdialog;

    /** end -- for subunitPanel* */

    /** start -- for bondsPanel* */
    private JPanel bondsPanel;

    private DefaultListModel bListModel;

    private JList bList;

    private JButton addNewBondB;

    /** end -- for bondsPanel* */

    public NewAssemblyDialog(Frame aFrame) {
        super(aFrame, true);

        setSize(750, 300);

        numSubunits = 0;
        initFrame();
    }

    private void initFrame() {

        newsubunitdialog = new NewSubunitDialog(this);

        /**
         * ************************start -- Setting up
         * mainpanel************************
         */
        mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createTitledBorder("New Assembly"));
        mainPanel.setLayout(new BorderLayout());

        initSubunitPanel(); //panel for subunit details
        initBondsPanel(); //panel for bond details
        //done = new JButton("DONE");
        //done.addActionListener(this);

        mainPanel.add(subunitPanel, BorderLayout.WEST);
        mainPanel.add(bondsPanel, BorderLayout.EAST);
        //mainPanel.add(done, BorderLayout.SOUTH);

        /**
         * ************************end -- Setting up
         * mainpanel************************
         */

        //getContentPane().add(mainPanel, BorderLayout.CENTER);
        //Create an array specifying the number of dialog buttons and their
        // text.
        options = new Object[1];
        options[0] = "DONE";

        //Create the JOptionPane.
        optionPane = new JOptionPane(mainPanel, JOptionPane.QUESTION_MESSAGE,
                JOptionPane.YES_OPTION, null, options);

        //Make this dialog display it.
        setContentPane(optionPane);

        //Handle window closing correctly.
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                /*
                 * Instead of directly closing the window, we're going to change
                 * the JOptionPane's value property.
                 */
                optionPane.setValue(new Integer(JOptionPane.CLOSED_OPTION));
            }
        });

        //Register an event handler that reacts to option pane state changes.
        optionPane.addPropertyChangeListener(this);

    }

    private void initSubunitPanel() {
        //setting up panel
        subunitPanel = new JPanel();
        subunitPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        subunitPanel.setLayout(new BoxLayout(subunitPanel, BoxLayout.Y_AXIS));

        //number of subunits display
        numSubunitsLabel = new JLabel("Number of subunits: " + numSubunits);

        //Create the list and put it in a scroll pane.
        sListModel = new DefaultListModel();
        //sListModel.addElement("Subunit #0"); -- if any subunits are to be
        // added by default
        sList = new JList(sListModel);
        sList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        //sList.setSelectedIndex(0);
        sList.addListSelectionListener(this);
        sList.setVisibleRowCount(4);
        JScrollPane sListScrollPane = new JScrollPane(sList);

        //initializing the 2 buttons
        displaySubunitDetailsB = new JButton("Display chosen subunit details");
        displaySubunitDetailsB.addActionListener(this);
        displaySubunitDetailsB.setEnabled(false); //should not be enabled
                                                  // unless a subunit is
                                                  // selected from list
        addNewSubunitB = new JButton("Add new subunit");
        addNewSubunitB.addActionListener(this);

        //adding the components to the panel
        subunitPanel.add(numSubunitsLabel);
        subunitPanel.add(sListScrollPane);
        subunitPanel.add(displaySubunitDetailsB);
        subunitPanel.add(addNewSubunitB);

    }

    private void initBondsPanel() {
        //setting up panel
        bondsPanel = new JPanel();
        bondsPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        bondsPanel.setLayout(new BoxLayout(bondsPanel, BoxLayout.Y_AXIS));

        //Create the list and put it in a scroll pane.
        bListModel = new DefaultListModel();
        bList = new JList(bListModel);
        bList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        bList.addListSelectionListener(this);
        bList.setVisibleRowCount(4);
        JScrollPane bListScrollPane = new JScrollPane(bList);

        //initializing button
        addNewBondB = new JButton("Add new bond");
        addNewBondB.addActionListener(this);

        //adding the components to the panel
        bondsPanel.add(new JLabel("Inter-subunit bindings:"));
        bondsPanel.add(bListScrollPane);
        bondsPanel.add(addNewBondB);

    }

    public void actionPerformed(ActionEvent e) {

        if (e.getSource().equals(addNewSubunitB)) { //add new subunit
            System.out.println("clicked to add new subunit");

            numSubunits++;
            numSubunitsLabel.setText("Number of subunits: " + numSubunits);

            //bring up the dialog to add a new subunit
            newsubunitdialog.setLocationRelativeTo(this);
            newsubunitdialog.setVisible(true);

            //add new subunit to the list
            sListModel.addElement("Subunit #" + (numSubunits - 1));

        } else if (e.getSource().equals(displaySubunitDetailsB)) { //display
                                                                   // subunit
                                                                   // details

            //debug
            System.out.println("clicked to display subunit details");

            int chosenSubunitIndex = sList.getSelectedIndex();
            if (chosenSubunitIndex == -1) {
                System.out
                        .println("Error, you must choose a subunit from the list first.");
            } else {
                System.out.println("(display the subunit properties)");
            }

        } else if (e.getSource().equals(addNewBondB)) { //add new inter-subunit
                                                        // bond
            System.out.println("clicked to add new inter-subunit bond");

            //add new bond to the list
            bListModel.addElement("#x - #y"); //some description of the subunit
                                              // bond e.g. between 1 and 3

        }

    }

    //This method is required by ListSelectionListener.
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == sList) { //from subunit list

            if (e.getValueIsAdjusting() == false) {

                if (sList.getSelectedIndex() == -1) {
                    //No selection, disable show subunit properties button
                    displaySubunitDetailsB.setEnabled(false);

                } else {
                    //Selection, enable show subunit properties button
                    displaySubunitDetailsB.setEnabled(true);
                }
            }
        }

    }

    /** This method clears the dialog and hides it. */
    public void clearAndHide() {
        setVisible(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();

        if (isVisible()
                && (e.getSource() == optionPane)
                && (JOptionPane.VALUE_PROPERTY.equals(prop) || JOptionPane.INPUT_VALUE_PROPERTY
                        .equals(prop))) {
            Object value = optionPane.getValue();

            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                //ignore reset
                return;
            }

            //Reset the JOptionPane's value.
            //If you don't do this, then if the user
            //presses the same button next time, no
            //property change event will be fired.
            optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);

            clearAndHide();
        }

    }

}

