
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * MainFrame class extends JFrame which is a container used for interactive
 * demonstration of self-assembly simulation
 * 
 * @see Test
 * @author Sue Yi Chew
 * @author Rori Rohlfs
 * @version 1.0 
 *  
 */

public class MainFrame extends JFrame implements ActionListener {

    private NewAssemblyDialog newAssemblyDialog;

    private NewSimulationDialog newSimulationDialog;

    private Simulation sim;

    private JPanel simulatorPane;

    private SimulatorGraphic simulatorGraph;

    public MainFrame(String title) {
        super(title);

        //setting up dialog for new simulation
        newSimulationDialog = new NewSimulationDialog(this);

        //setting up dialog for new assembly
        newAssemblyDialog = new NewAssemblyDialog(this);

	//line below should be uncommented when xml file loading/saving is in place
        //setJMenuBar(createMenuBar());

        simulatorPane = (JPanel) createContentPane();

        //super class method
        setContentPane(simulatorPane);
    }

    /**
     * Creates the menu for this frame
     * 
     * @return JMenuBar
     */

    private JMenuBar createMenuBar() {
        JMenuBar menuBar;
        JMenu menu;
        JMenuItem menuItem;

        //create the menu bar
        menuBar = new JMenuBar();

        /**
         * creates the "File" menu, associates it with Alt+F
         */
        menu = new JMenu("File");
        menu.setMnemonic(KeyEvent.VK_F);
        menuBar.add(menu);

        /**
         * creates the "New Simulation" menu item, associates it with Alt+N,
         * adds it to "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("New Simulation", KeyEvent.VK_N);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("newSimulation");
        menu.add(menuItem);

        /**
         * creates the "Load Simulation" menu item, associates it with Alt+L,
         * adds it to "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Load Simulation", KeyEvent.VK_L);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("loadSimulation");
        menu.add(menuItem);

        /**
         * creates the "Save" menu item, associates it with Alt+S, adds it to
         * "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Save", KeyEvent.VK_S);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("save");
        menu.add(menuItem);

        //adds separator for "Quit" menu item
        menu.addSeparator();

        /**
         * creates the "Quit" menu item, associates it with Alt+Q, adds it to
         * "File" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Quit", KeyEvent.VK_Q);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("quit");
        menu.add(menuItem);

        /**
         * creates the "Assembly" menu, associates it with Alt+A
         */
        menu = new JMenu("Assembly");
        menu.setMnemonic(KeyEvent.VK_A);
        menuBar.add(menu);

        /**
         * creates the "Add new assembly" menu item, associates it with Alt+S,
         * adds it to "Assembly" menu, sets the action command for this button
         */
        menuItem = new JMenuItem("Add new assembly", KeyEvent.VK_S);
        menuItem.addActionListener(this);
        menuItem.setActionCommand("addAssembly");
        menu.add(menuItem);

        return menuBar;
    }

    /**
     * Creates content pane that will replace default content pane of this
     * JFrame
     * 
     * @return Container
     */
    private Container createContentPane() {
        /*
         * Creates a new buffered JPanel, sets the behavior of JPanel
         */
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setLayout(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(600, 600));

	//Initialize the Simulation that will be run here
	/*
         * Creates dimer self-assembly simulation
         */
        Dimer t = new Dimer();

	/*
         * Creates Actin for actin self-assembly simulation
         */
        //Actin t = new Actin();

        /*
         * Creates Icosahedral for icosahedral self-assembly simulation
         */
        //Icosahedral t = new Icosahedral();



        /*
         * Uses static method getSim(), returns Simulation
         */
        sim = t.getSim();

        /**
         * returns SimulatorGraphic which extends JPanel
         */
        simulatorGraph = sim.startGraphic();//new SimulatorGraphic(sim);

        /**
         * Creates JToolbar for controls and debugging, buttons in toobar are
         * associated with methods in Simulation class
         */

        JToolBar toolbar = new JToolBar();

        /**
         * creates the "run" button for starting simulation , adds it to
         * toolbar, sets the action command for this button
         */
        JButton runB = new JButton("Run");
        runB.addActionListener(this);
        runB.setActionCommand("run");
        toolbar.add(runB);

        /**
         * creates the "Step" button for debugging , adds it
         * to toolbar, sets the action command for this button
         */
        JButton stepB = new JButton("Step");
        stepB.addActionListener(this);
        stepB.setActionCommand("step");
        toolbar.add(stepB);


        /**
         * creates the "Relax" button for debugging , adds it
         * to toolbar, sets the action command for this button
         */
	/*
	JButton relaxB = new JButton("Relax");
        relaxB.addActionListener(this);
        relaxB.setActionCommand("relax");
        toolbar.add(relaxB);
	*/	

        /**
         * creates the "Force Relax" button for debugging , adds it 
	 * to toolbar, sets the action command for this button
         */
        /*
	JButton frelaxB = new JButton("Force Relax");
        frelaxB.addActionListener(this);
        frelaxB.setActionCommand("frelax");
        toolbar.add(frelaxB);
	*/

        /**
         * creates the "Relax Lots" button for debugging , adds it 
	 * to toolbar, sets the action command for this button
         */
	/*
        JButton relaxlotsB = new JButton("Relax Lots");
        relaxlotsB.addActionListener(this);
        relaxlotsB.setActionCommand("relaxlots");
        toolbar.add(relaxlotsB);
	*/

        //add components(simulatorGraph and toolbar) to contentpane container
        contentPane.add(simulatorGraph, BorderLayout.CENTER);
        contentPane.add(toolbar, BorderLayout.SOUTH);

        return contentPane;

    }

    /**
     * Updates the simulation graphic
     * 
     * @return Container
     */
    private Container updateContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(true);
        contentPane.setLayout(new BorderLayout());
        JPanel display = new SimulatorGraphic(sim);

        //add components to contentpane
        contentPane.add(display, BorderLayout.CENTER);

        return contentPane;
    }

    /**
     * Listens to user-input events and execute those events.  for example,
     * runs the simulation when the run button is pressed
     * 
     * @param e
     *            ActionEvent, executed by choosing menu items or buttons
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("newSimulation")) {
            //bring up the dialog to start a new simulation
            newSimulationDialog.setLocationRelativeTo(this);
            newSimulationDialog.setVisible(true);
        } 
	else if (e.getActionCommand().equals("loadSimulation")) {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                File file = fc.getSelectedFile();

                //Insert code to open file here

                System.out.println("File to open: " + file.getName());
            }
	    else {
                System.out.println("Open command cancelled by user.");
            }

        }
	else if (e.getActionCommand().equals("addAssembly")) {

            //bring up the dialog to add a new assembly to this simulation
            newAssemblyDialog.setLocationRelativeTo(this);
            newAssemblyDialog.setVisible(true);
	}
	else if (e.getActionCommand().equals("relax")) {
            sim.relaxAssemblies();
        }
	else if (e.getActionCommand().equals("frelax")) {
            sim.forceRelaxAssemblies();
        }
	else if (e.getActionCommand().equals("relaxlots")) {
            sim.relaxAssembliesLots();
        }
	else if (e.getActionCommand().equals("run")) {
            sim.run();
        }
	else if (e.getActionCommand().equals("step")) {
            sim.step();
        }
    }
}

