/**
 * FormBondEvent extends Event and is specified with two BindingSites involved
 * in bond forming event
 * 
 * @author Sue Yi Chew
 * @version 1.0
 */
public class FormBondEvent extends Event {

    private BindingSite bs;

    private BindingSite partner;

    /**
     * Constructs a FormBondEvent using the specified parameters
     * 
     * @param curTime
     *            double, time when the Event was found/sampled
     * @param endTime
     *            double, time when the Event will be complete
     * @param assemNamesInvolved
     *            String[], names of Assemblies involved in the event
     * @param bs
     *            BindingSite, the BindingSite forming the bond from the first Assembly named in assemNamesInvolved
     * @param partner
     *            BindingSite, the BindingSite forming the bond from the second Assembly named in assemNamesInvolved
     */
    public FormBondEvent(double curTime, double endTime,
            String[] assemNamesInvolved, BindingSite bs, BindingSite partner) {
        super(curTime, endTime, assemNamesInvolved);
        this.bs = bs;
        this.partner = partner;
    }

    /**
     * Returns the primary BindingSite involved in this FormBondEvent
     * 
     * @return BindingSite
     */
    public BindingSite getBS() {
        return bs;
    }

    /**
     * Returns secondary BindingSite to be involved in this FormBondEvent
     * 
     * @return BindingSite
     */
    public BindingSite getPartner() {
        return partner;
    }

    /**
     * Returns a String version of this FormBondEvent
     * 
     * @return String
     */
    public String toString() {
        String assemNames = "";
        String[] assemNamesInvolved = super.getAssemNamesInvolved();
        for (int i = 0; i < assemNamesInvolved.length; ++i) {
            assemNames += assemNamesInvolved[i] + " ";
        }

        return ("FormBondEvent: (Assemblies: " + assemNames + ", PostTime: "
                + super.getPostTime() + ", EndTime: " + super.getEndTime()
                + ", bs id " + bs.getid() + " on subunit: " + bs.getSubunitID()
                + ", bs's partner id " + partner.getid() + " on subunit: "
                + partner.getSubunitID() + ")");

    }
}