import java.util.Vector;
import javax.vecmath.*;



/**
 * Domain class holds Conformation information for a Domain in a Subunit
 * @author Rori Rohlfs
 * @version 1.0	
 */
public class Domain {	       	
    Vector myconfs;			//set of possible Conformations 
    Vector3d mypos = new Vector3d();
    int dmid;        //Domain id

      
    /**
     * Constructs a Domain with specified parameters (SubunitType ID, Vector of Conformations,
     * Vector of Positions, Domain id)
     *  
     * @param stid		int, the ID of the SubunitType associated with this Domain
     * @param c			Vector of Conformations
     * @param pos		Vector3D postion of this Domain in the Subunit
     * @param di                Domain id
     */
    public Domain(String stname, Vector c, Vector3d pos, int di) {
        myconfs = c;
        for(int i=0; i<myconfs.size(); i++) {
            Conformation cur = (Conformation) myconfs.elementAt(i);
            cur.setSubunitType(stname, dmid);
        }
        mypos = pos;
        dmid = di;
    }
        
   /**
    * Returns vector of Conformations for this Domain
    * @return Vector of Conformations
    */
    public Vector getConfs() {
        return myconfs;
    }
    
    /**
     * Returns the position of this Domain in the Subunit
     * @return Vector3d
     */
    public Vector3d getPos() {
        return mypos;
    }
} 
