
import java.util.Vector;

/**
 * Checks if 2 subunits are in the same Assembly
 * 
 * @author Sue Yi Chew
 * @author Tiequan Zhang
 * @version 1.0
 *  
 */
public class CheckConnected {

    /**
     * Vector of Integers which represent the ID of Subunits that have been
     * checked and are in the same Assembly
     */
    private Vector seen;

    /**
     * Constructs an empty CheckConnected object
     */
    public CheckConnected() {
        seen = new Vector();
    }

    /**
     * Checks if Subunit sub1 and Subunit sub2 are in the same Assembly
     * 
     * @param sub1
     *            Subunit
     * @param sub2
     *            Subunit
     * @return boolean
     *  
     */

    public boolean isConnected(Subunit sub1, Subunit sub2) {
        Vector sub1Conns = getConnected(sub1);
        /**
         * Because seen is used by both sub1 and sub2, it need to be clear
         */
        seen.clear();
        Vector sub2Conns = getConnected(sub2);
        seen.clear();

        /**
         * If sub1Conns(all Subunits of Assembly in which sub1 is) and
         * sub2Conns(all Subunits of Assembly in which sub1 is) have a common
         * Subunit, then they are connected, return true. Or else they are
         * disconnected, return false.
         */
        for (int i = 0; i < sub1Conns.size(); ++i) {
            for (int j = 0; j < sub2Conns.size(); ++j) {
                if (((Subunit) sub1Conns.get(i)).equals((Subunit) (sub2Conns
                        .get(j)))) {
                    return true;
                }

            }
        }
        return false;

    }

    /**
     * Returns Vector containing all the subunits are in the same Assembly with
     * Subunit sub, including sub itself. Similar to Djikstra algorithm
     * 
     * @param sub
     *            Subunit
     * @return Vector of Subunits
     */
    public Vector getConnected(Subunit sub) {
        Vector ret = new Vector();
        ret.add(sub);
        markSubunit(sub);
        return getConnectedRec(ret, sub);
    }

    /**
     * Finds all Subunit objects that are in the same Assembly as Subunit sub
     * marks them(includingt Subunit sub) and return a Vector of all Subunits
     * 
     * @param v
     *            Vector
     * @param sub
     *            Subunit
     * @return Vector of all Subunit objects in the same Assembly
     *  
     */
    private Vector getConnectedRec(Vector v, Subunit sub) {
        Subunit curSub;
        //Vector of Subunit connected to Subunit sub
        Vector boundSubunits = sub.getBoundSubunits();

        for (int i = 0; i < boundSubunits.size(); ++i) {
            curSub = (Subunit) boundSubunits.get(i);
            if (!isMarkedSubunit(curSub)) {
                v.add(curSub);
                markSubunit(curSub);
                getConnectedRec(v, curSub);
            }

        }
        return v;
    }

    /**
     * Checks if Subunit s has been marked by checking if Vector Seen contains
     * the Subunit ID of s
     * 
     * @param s
     *            Subunit
     * @return boolean
     *  
     */
    private boolean isMarkedSubunit(Subunit s) {
        return seen.contains(new Integer(s.getid()));

    }

    /**
     * Adds the ID of Subunit s to Vector seen
     * 
     * @param s
     *            Subunit
     *  
     */
    private void markSubunit(Subunit s) {
        seen.add(new Integer(s.getid()));
    }

}