/*
 *	@(#)PickTest.java 1.9 02/10/21 13:48:53
 *
 * Copyright (c) 1996-2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
 * OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
 * FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that Software is not designed,licensed or intended
 * for use in the design, construction, operation or maintenance of
 * any nuclear facility.
 */

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.*;
import java.awt.Point;
import java.util.*;
import javax.management.JMRuntimeException;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.picking.behaviors.*;
import com.sun.j3d.utils.picking.*;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.behaviors.vp.*;

import javax.media.j3d.*;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.vecmath.*;


/**
 * This class creates main frame for graphical tool 
 * 
 * @author Peter Woo Tae Kim
 * @version 1.0
 */


public class ToolTest extends Applet implements ActionListener{

	//Center of icosahedron
	private Point3d icosahedronCenter = new Point3d(0,0,0);
	
	//Icosahedron object
	private IcosahedronTSA geom;
	
	//Array of twenty faces of triangles on icosahedron
	private TriangleData[] triangles = new TriangleData[20];
	
	//x, y, z field that user inputs
	private JTextArea xarea;
	private JTextArea yarea;
	private JTextArea zarea;
	
	//Scene objects
	private BranchGroup scene;
	private BoundingSphere bounds;
	
	//Number of triangles that user will be using
	private int triangleFaces = 20;
	
	//Counter for how many different subunit types are made
	private int counter = 0;
	
	//Class that handles connecting subunits
	private ConnectSubunits conSubts;
	
	
	/**
	 * 
	 * This method creates the scene objects
	 * 
	 * @param Canvas3D canvas
	 * @return BranchGroup
	 */
	public BranchGroup createSceneGraphic(Canvas3D canvas)
	{
		 BranchGroup objRoot = new BranchGroup();
	     objRoot.setCapability(BranchGroup.ALLOW_DETACH);
	     objRoot.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
	     objRoot.setCapability(Group.ALLOW_CHILDREN_WRITE);

		 TransformGroup objScale = new TransformGroup();
		 Transform3D t3d = new Transform3D();
		 t3d.setScale(1.0);
		 objScale.setTransform(t3d);
		 objRoot.addChild(objScale);		 
		 objScale.addChild(createIcosahedron(1.0, objRoot));
		 
		 bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

		 // Add a light.
		 Color3f lColor = new Color3f(1.0f, 1.0f, 1.0f) ;
		 Vector3f lDir  = new Vector3f(0.0f, 0.0f, -1.0f) ;

		 DirectionalLight lgt = new DirectionalLight(lColor, lDir) ;
		 lgt.setInfluencingBounds(bounds) ;
		 objRoot.addChild(lgt) ;		    
		 return objRoot;		 
	}
	/**
	 * 
	 * This method creates icosahedron object
	 * 
	 * @param double scale 
	 * @param BranchGroup root
	 * @return Group
	 */
	private Group createIcosahedron(double scale, BranchGroup root)
	{
		
		Shape3D shape = null;		
		Transform3D t = new Transform3D();
		t.set(scale, new Vector3d(icosahedronCenter.x, icosahedronCenter.y, icosahedronCenter.z));
		TransformGroup objTrans = new TransformGroup(t);
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		objTrans.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
		objTrans.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		
		TransformGroup spinTg = new TransformGroup();
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		spinTg.setCapability(TransformGroup.ENABLE_PICK_REPORTING);
		
		Appearance appearance = new Appearance();
		geom = new IcosahedronTSA();
		  
		Material m = new Material() ;
		m.setLightingEnable(false) ;
		appearance.setMaterial(m) ;
		  
		shape = new Shape3D(geom,appearance);		 
		shape.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE);
		  
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		shape.setCapability(Shape3D.ENABLE_PICK_REPORTING);
		shape.setPickable(false);
		PickTool.setCapabilities(shape, PickTool.INTERSECT_FULL);
		spinTg.addChild(shape);
		     		     
		objTrans.addChild(spinTg);
		
		for(int i = 0; i < triangleFaces; i++)
		{
			TriangleData triangle = new TriangleData(root);
			triangle.setVerticies((Point3d[]) geom.triangles.get(i));
			triangles[i] = triangle;
		}		
		return objTrans;		
	}

	/**
	 * 
	 * This method is called when user adds new subunits onto scene
	 * or tries to output the result into XML file.
	 * 
	 * @param ActionEvent e
	 */
	public void actionPerformed(ActionEvent e)
	{	
		
		//It reads x, y, z value that user gave
	    String value = e.getActionCommand();
	    if(value.equals("getPos"))
	    {
	    	boolean proceed = true;
	    	Double xPos = null;
	    	Double yPos = null;
	    	Double zPos = null;
	    	
	    	BranchGroup bg = new BranchGroup();
	    	bg.setCapability(bg.ALLOW_CHILDREN_WRITE);
	    	bg.setCapability(bg.ALLOW_CHILDREN_READ);
	    	
	    	//Checks wheather it is correct number format or not.
	    	try{	    		
		    	xPos = new Double(xarea.getText());
		    	yPos = new Double(yarea.getText());
		    	zPos = new Double(zarea.getText());
	    	}
	    	catch(Exception except)
	    	{
	    		JOptionPane.showMessageDialog(this, "Positions does not have correct number format");	    		
	    		proceed = false;
	    	}
	    	
		    if(proceed)
		    {
		    	// It goes through each triangles and copies subunits using 3-fold axis
		    	for(int i = 0; i < triangleFaces; i++)
		    	{
		    		triangles[i].addSubunits(xPos.doubleValue(), yPos.doubleValue(), zPos.doubleValue(), bg, counter);
		    	}
		    	scene.addChild(bg);
		    	counter++;
		    	conSubts.updateCounter(counter);
		    }
	    }
	    // writes to XML file
	    else if(value.equals("writeToFile"))
	    {
	    	conSubts.writeToXML();
	    }
	    
	}
	
	/**
	 * 
	 * This method creates panel for different buttons, and x,y,z field
	 * 
	 * 
	 * @param JPanel panel
	 */
	private void setupGUI(JPanel panel) 
	{

		xarea = new JTextArea();
		yarea = new JTextArea();
		zarea = new JTextArea();
		
	    panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
	    panel.setBorder(new BevelBorder(BevelBorder.LOWERED));
	   
	    //This is a button that creats subunits
	    JButton addB = new JButton("Add");
	    panel.add(new JLabel("X pos = "));
	    panel.add(xarea);
	      
	    panel.add(new JLabel("Y pos = "));
	    panel.add(yarea);

	    panel.add(new JLabel("Z pos = "));
	    panel.add(zarea);

	    panel.add(addB);
	    addB.addActionListener(this);
	    addB.setActionCommand("getPos");
	    
	    //button for writing to XML
	    JButton writeB = new JButton("WriteToFile");
	    panel.add(writeB);
	    writeB.addActionListener(this);
	    writeB.setActionCommand("writeToFile");
	}
	/**
	 * This method creates all the necessary objects and frames for initial steps
	 * 
	 */
	public void init()
	{		
		setLayout(new BorderLayout());
		Canvas3D c = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
		add("Center", c);

		JPanel guiPanel = new JPanel();
		setupGUI(guiPanel);
		add(guiPanel, BorderLayout.SOUTH);
		  
		scene = createSceneGraphic(c);

		SimpleUniverse u = new SimpleUniverse(c);
			

		conSubts = new ConnectSubunits(c, scene, triangles, triangleFaces, this);
		conSubts.setSchedulingBounds (bounds);
		scene.addChild (conSubts);
		
		u.getViewingPlatform().setNominalViewingTransform();
		View view = u.getViewer().getView();
		u.addBranchGraph(scene);
		 
		 
		OrbitBehavior orbit = new OrbitBehavior(c, OrbitBehavior.REVERSE_ALL);
		orbit.setSchedulingBounds(bounds);
		u.getViewingPlatform().setViewPlatformBehavior(orbit);
	}
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		new MainFrame(new ToolTest(), 800, 800);
	}

}
