import java.util.*;
import javax.vecmath.*;;
/**
 * 
 * This class stores the information for subunit type
 * 
 * @author Peter Woo Tae Kim
 *
 */
public class SubunitType {

	private Subunit[] subs;
	private String name;
	private Vector3d upVec;
	private int counter;
	
	public SubunitType()
	{
		subs = new Subunit[3];
		name = null;
		upVec = null;
		counter = 0;
	}
	
	/**
	 * 
	 * This method adds subunit to subunit type
	 * 
	 * @param Tuple3d pos
	 */
	public void addSub(Tuple3d pos)
	{
		Subunit sub = new Subunit(counter, pos);
		subs[counter] = sub;
		counter++;
	}
	
	/**
	 * 
	 * Returns subunit with give subunit id
	 * 
	 * @param int id
	 * @return Subunit
	 */
	public Subunit getSub(int id)
	{
		return subs[id];
	}
	
	/**
	 * 
	 * Sets the name of subunit type
	 * 
	 * @param String subtName
	 */
	public void setName(String subtName)
	{
		name = subtName;
	}
	
	/**
	 * returns the name of subunit type
	 * 
	 * @return String
	 */
	public String getName()
	{
		return name;
	}
}
