import java.util.*;
import javax.vecmath.*;
/**
 * 
 * This class stores the information necessary for subunits
 * 
 * @author Peter Woo Tae Kim
 *
 */
public class Subunit {

	private int subId;
	private Point3d subPos;
	private Vector bsts;
	private int counter = 0;
	private Subunit primarySubunit;
	private Subunit connectSubunit;
	
	public Subunit(int subId, Tuple3d pos)
	{
		subPos = new Point3d(pos);
		bsts = new Vector();
	}
	/**
	 * 
	 * returns subunit id
	 * 
	 * @return int
	 */
	public int getSubId()
	{
		return subId;
	}
	
	/**
	 * 
	 * returns position of this subunit
	 * 
	 * @return Point3d
	 */
	public Point3d getPos()
	{
		return subPos;
	}
	
	/**
	 * 
	 * Sets the id of this subunit
	 * 
	 * @param int id
	 */
	public void setSubId(int id)
	{
		subId = id;
	}
	
	/**
	 * 
	 * Sets the position this subunit
	 * 
	 * @param Point3d pos
	 */
	public void setPos(Tuple3d pos)
	{
		subPos = new Point3d(pos);
	}
	
	/**
	 * 
	 * Gives names to binding site types that belongs to this subunit
	 * 
	 * @param BindingSiteType bst
	 * @param int subtId
	 */
	public void addBsts(BindingSiteType bst, int subtId)
	{
		bsts.add(bst);
		if(counter == 0)
			bst.setName("bst"+subtId+"a");
		else if(counter == 1)
			bst.setName("bst"+ subtId+"b");
		else if(counter == 2)
			bst.setName("bst" + subtId+"c");
		else if(counter == 3)
			bst.setName("bst" + subtId+"d");
		else if(counter == 4)
			bst.setName("bst" + subtId+"e");
		else if(counter == 5)
			bst.setName("bst" + subtId+"f");
		else if(counter == 6)
			bst.setName("bst" + subtId+"g");
		else if(counter == 7)
			bst.setName("bst" + subtId+"h");

		else
		{
			System.out.println("Currently there can be upto 3 binding site types");
			System.exit(-1);
		}
		bst.setPrimaryReference(primarySubunit);
		bst.setConnectReference(connectSubunit);
		counter++;
	}

	/**
	 * 
	 * returns binding site type of this subunit with given id
	 * 
	 * @param int bstId
	 * @return BindingSiteType
	 */
	public BindingSiteType getBindingSiteType(int bstId)
	{
		return (BindingSiteType) bsts.get(bstId);
	}

	/**
	 * 
	 * Returns how many differen binding sites were added to this subunit.
	 * 
	 * @return int
	 */
	public int getBindingSiteCounter()
	{
		return counter;
	}
}
