import javax.vecmath.*;
/**
 * 
 * This class stores the information for binding site types
 * 
 * @author Peter Woo Tae Kim
 *
 */
public class BindingSiteType {

	//Tip of binding site postion from subunit
	private Vector3d pos;
	
	//Orientation of binding site. It is necessary for DESSA
	private Vector3d orientation;
	
	//Name of this binding site
	private String name;
	
	//Name of partner's binding site
	private String partnerName;
	
	
	private Subunit primarySubunit;
	private Subunit connectSubunit;
	
	//Length of bindingSites
	private double length;
	
	/**
	 * Constructor
	 *
	 */
	public BindingSiteType()
	{
		pos = null;
		orientation = null;
		name = null;
		partnerName = null;
	}
	/**
	 * This method stores the postion of bindingsite
	 * 
	 * @param Tuple3d bspos
	 */
	public void setPos(Tuple3d bspos)
	{
		pos = new Vector3d(bspos);
	}
	
	/**
	 * 
	 * This method stores the name of this binding site
	 * 
	 * @param String bsName
	 */
	public void setName(String bsName)
	{
		name = bsName;
	}
	
	/**
	 * 
	 * This method stores the name of this binding site
	 *
	 * @param String partName
	 */
	
	public void setPartnerName(String partName)
	{
		partnerName = partName;
	}
	
	/**
	 * 
	 * This method returns the position of this binding site
	 * 
	 * @return Vector3d
	 */
	public Vector3d getPos()
	{
		return pos;
	}
	
	/**
	 * 
	 * This method returns the name of this binding site
	 * 
	 * @return String
	 */
	public String getName()
	{
		return name;
	}
	
	/**
	 * 
	 * This method returns the partner's name of this binding site
	 * 
	 * @return String
	 */
	public String getPartnerName()
	{
		return partnerName;
	}
	
	public void setPrimaryReference(Subunit prim)
	{
		primarySubunit = prim;
	}
	
	public void setConnectReference(Subunit connect)
	{
		connectSubunit = connect;
	}
	
	public Subunit getPrimaryReference()
	{
		return primarySubunit;
	}
	
	public Subunit getConnectReferece()
	{
		return connectSubunit;
	}
	/**
	 * 
	 * This method sets the length of binding site
	 * 
	 * @param double myLength
	 */
	public void setLength(double myLength)
	{
		length = myLength;
	}
	
	/**
	 * 
	 * This method returns the length of binding site
	 * 
	 * @return double
	 */
	public double getLength()
	{
		return length;
	}
}
