/*
 *  linux/include/asm-arm/arch-pxa/glencoe.h
 *  Author: Matthias Ihmig <m.ihmig@mytum.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef ASM_ARCH_GLENCOE_H
#define ASM_ARCH_GLENCOE_H

/* Glencoe specific GPIO functions and assignments*/

#define GLN_GPIO_GPIO0		0	/* IN:  General purpose input */
#define GLN_GPIO_SLEEPWAKE	1	/* IN:  Sleep/Wake button */

#define GLN_GPIO_nGEM_WAKE	9	/* OUT: GEM module wake up output */
#define GLN_GPIO_nGEM_SLEEP	10	/* IN:  GEM module sleep input, 0=module asleep, 1=module awake*/
#define GLN_GPIO_nGEM_RST	11	/* OUT: GEM module reset, 0=in reset, 1=out of reset */
#define GLN_GPIO_nGEM_PWR_DWN	12	/* OUT: GEM module power, 0=power off, 1=power on */

#define GLN_GPIO_KP_DKIN7	13	/* IN:  Keypad Direct Key input 7*/
#define GLN_GPIO_LCD_BRIGHTNESS	16	/* OUT: LCD Brightness output - PWM control */

#define GLN_GPIO_nUSIM_CD_CPU	17	/* IN:  USIM card detect for when CPU is connected to SIM card, 0=card inserted, 1=no SIM card inserted */
#define GLN_GPIO_MMC_PWR_ON	22	/* OUT: MMC/SD card power, 0=off, 1=on */
#define GLN_GPIO_nMMC_CARD_DET	27	/* IN:  MMC/SD card detect input, 0=card inserted, 1=card not inserted */
#define GLN_GPIO_nGREEN_LED	33	/* OUT: Green general purpose LED, 0=on, 1=off */
#define GLN_GPIO_nBLUE_LED	80	/* OUT: Blue general purpose LED, 0=on, 1=off */
#define GLN_GPIO_BL_PWR_ON	86	/* OUT: Blacklight power control, 0=off, 1=on */
#define GLN_GPIO_LCD_PWR_ON	87	/* OUT: LCD power control, 0=off, 1=on */

#define GLN_GPIO_nCF1_IRQ	100	/* IN:  Compact Flash card 1 interrupt, 0=pending, 1=no int pending */
#define GLN_GPIO_CF1_RST	101	/* OUT: Compact Flash card 1 reset, 0=card not in reset, 1=card in reset */
#define GLN_GPIO_CF_PWR_ON	102	/* OUT: Compact Flash power, 0=power off, 1=power on */
#define GLN_GPIO_nCF1_CARD_DET	103	/* IN:  Compact Flash card 1 detect, 0=card inserted, 1=no card inserted */

#define GLN_GPIO_nCF2_IRQ	104	/* IN:  Compact Flash card 2 interrupt, 0=pending, 1=no int pending */
#define GLN_GPIO_CF2_RST	105	/* OUT: Compact Flash card 2 reset, 0=card not in reset, 1=card in reset */
#define GLN_GPIO_nCF2_CARD_DET	106	/* IN:  Compact Flash card 2 detect, 0=card inserted, 1=no card inserted */

#define GLN_GPIO_nAC97_INT	107	/* IN:  AC97 codec interrupt, 0=pending, 1=no int pending */
#define GLN_GPIO_nAUDIO_PWR_DWN	108	/* OUT: Audio subsection power down, 0=powered on, 1=power off */

// PWM registers for backlight
#define GLN_BACKLIGHT_PWM_PERVAL	PWM_PERVAL0
#define GLN_BACKLIGHT_PWM_PWDUTY	PWM_PWDUTY0
#define GLN_BACKLIGHT_PWM_CTRL		PWM_CTRL0
#define GLN_BACKLIGHT_PWM_MD		GPIO16_PWM0_MD
#define GLN_BACKLIGHT_PWM_CKEN		CKEN0_PWM0


/*
 * LED macros
 */

#define GLN_SW_GREEN_LED_OFF (GPIO_set(GLN_GPIO_nGREEN_LED))
#define GLN_SW_GREEN_LED_ON  (GPIO_clr(GLN_GPIO_nGREEN_LED))
#define GLN_SW_BLUE_LED_OFF  (GPIO_set(GLN_GPIO_nBLUE_LED))
#define GLN_SW_BLUE_LED_ON   (GPIO_clr(GLN_GPIO_nBLUE_LED))
#define GLN_SW_BL_PWR_ON     (GPIO_set(GLN_GPIO_BL_PWR_ON))
#define GLN_SW_BL_PWR_OFF    (GPIO_clr(GLN_GPIO_BL_PWR_ON))
#define GLN_SW_LCD_PWR_ON    (GPIO_set(GLN_GPIO_BL_PWR_ON))
#define GLN_SW_LCD_PWR_OFF   (GPIO_clr(GLN_GPIO_BL_PWR_ON))

#define HEARTBEAT_LED_ON     GLN_SW_GREEN_LED_ON
#define HEARTBEAT_LED_OFF    GLN_SW_GREEN_LED_OFF
#define SYS_BUSY_LED_ON      GLN_SW_BLUE_LED_ON
#define SYS_BUSY_LED_OFF     GLN_SW_BLUE_LED_OFF

#endif
