/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

/* Create a RS, a CPU Reserve, and attach a process to the RS	*/
/*			By Luca Abeni				*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>


void print_usage(char *cmdname){
  printf("Usage: %s <Reserved Time: ms> <period: ms> <pid>\n", cmdname);
}

int main(int argc, char *argv[])
{
  rk_resource_set_t rs;
  rk_reserve_t	cpu_rsv;
  rk_reserve_param_data_t p;
  cpu_reserve_attr_data_t attr;
  int load = 10;   
  int period = 1000; 
  //  int hard = 1;
  int pid, res;
  
  if (argc != 4){
    print_usage(argv[0]);
    return -1;
  }
 
  rs = rk_resource_set_create("");
  if (rs == NULL) {
    fprintf(stderr, "%s: could not create resource set.\n", argv[0]);
    exit(-1);
  }

  load = atoi(argv[1]);
  period = atoi(argv[2]);
  pid = atoi(argv[3]);
  
#if 0
  p.enf_mode = RSV_HARD; 
  p.sch_mode = RSV_HARD;
  p.rep_mode = RSV_HARD;
#else
  p.enf_mode = RSV_SOFT; 
  p.sch_mode = RSV_SOFT;
  p.rep_mode = RSV_SOFT;
#endif

  attr.compute_time.tv_sec = load/1000;
  attr.compute_time.tv_nsec = (load%1000) * 1000000;
  attr.period.tv_sec = period/1000;
  attr.period.tv_nsec = (period%1000) * 1000000;
  attr.deadline = attr.period;
  
  printf("reserve is set for (%d,%d) in (%d,%d) w/ deadline (%d,%d) \n", 
	 (int)attr.compute_time.tv_sec,
	 (int)attr.compute_time.tv_nsec,
	 (int)attr.period.tv_sec,
	 (int)attr.period.tv_nsec,
	 (int)attr.deadline.tv_sec,
	 (int)attr.deadline.tv_nsec);
  
  attr.blocking_time.tv_sec = (long int) 0;
  attr.blocking_time.tv_nsec = (long int) 0;
  attr.start_time.tv_sec = (long int) 0;
  attr.start_time.tv_nsec = (long int) 0; 
  attr.reserve_type = p;
  cpu_rsv = rk_cpu_reserve_create(rs, &attr);

  res = rk_resource_set_attach_process(rs, pid);
  if (res != 1) {
    printf("Result: %d...\n", res);
  }
  printf("Resource Set (0x%x)=(%d) CPU Reserve (0x%x)=(%d)\n", 
	 (int)rs, (int)rs, (int)cpu_rsv, (int)cpu_rsv);
  
  return (int)cpu_rsv; 
}
