/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <wait.h>

#define NUM_CHILDREN 10

/* This is the body of the time consuming tasks */
void childbody(int childnum)
{
    pid_t whoami;
    int i, j, count;

    whoami = getpid();
    printf("Child %d starting\n", whoami);

    count = 300000;
    for (i = 0; i < 100000; i++) {
	for (j = 0; j < count; j++) {
        }
    }

    printf("Child %d diing\n", whoami);
    exit(0);
}

int main(int argc, char *argv[])
{
  pid_t child_pid[NUM_CHILDREN];
  int i;

  for(i=0; i<NUM_CHILDREN; i++)
    child_pid[i] = -1;

  for(i=0; i<NUM_CHILDREN; i++) {
    /* Create child */
    child_pid[i] = fork();
    if (child_pid[i] < 0) {
      perror("Error in fork()");
    }
    if (child_pid[i] == 0) {
      childbody(i);
    
      /* The child exits, so execution cannot arrive here */
      printf("ARRRG!!!! Why am I here?\n");
      exit(-1);
    }
  }
    
  /* And now, as a good father, wait for the children to die... */
  for(i=0; i<NUM_CHILDREN; i++)
    wait(&child_pid[i]);
  
  return 0;
}
