/* 
 * Copyright 2000-2003 Intel Corporation All Rights Reserved.
 * This file is for xsc2 PMU Access Assembly function
 */

.text

/*
@
@ pmu_reg_read - Read the PMU Register
@
@ Description:
@ 	This routine reads the designated PMU register via CoProcesser 14.
@
@ Input Parameters:
@       r0 - arg1, PMU register number to read.  Number between 0 to 8
@	if r0 contains:
@		0 -> PMNC,  PMU Control Register
@		1 -> CCNT,  PMU Clock Counter
@		2 -> PMN0,  PMU Count Register 0
@		3 -> PMN1,  PMU Count Register 1
@		4 -> PMN2,	PMU Count Register 2
@		5 -> PMN3,  PMU Count Register 3
@		6 -> INTEN, PMU Interupt Enable Register
@		7 -> FLAG,  PMU Overflow Flag Status Register
@		8 -> EVTSEL	PMU Event Select Register			
@
@ Returns:
@	r0 - 32-bit value read from CoProcessor
@    
@ Registers Modified:
@	CoProcessor Register Modified: None
@	General Purpose Registers Modified: r0	
@
@ NOTE:  
@	Error checking not included
@
*/
.global pmu_reg_read;
.align 0;
pmu_reg_read:
    cmp     	r0, #8
    addls	pc, pc, r0, lsl #2
    b		RRet
    b		RdPMNC
    b		RdCCNT
    b		RdPMN0
    b		RdPMN1
    b		RdPMN2
    b		RdPMN3
    b		RdINTEN
    b		RdFLAG
    b		RdEVTSEL

RdPMNC:  
    mrc     	p14, 0, r0, c0, c1, 0		@ Read PMNC
    b       	RRet
RdCCNT: 
    mrc     	p14, 0, r0, c1, c1, 0		@ Read CCNT
    b		RRet
RdPMN0:
    mrc     	p14, 0, r0, c0, c2, 0		@ Read PMN0
    b		RRet
RdPMN1:
    mrc     	p14, 0, r0, c1, c2, 0		@ Read PMN1
    b		RRet
RdPMN2:
    mrc     	p14, 0, r0, c2, c2, 0		@ Read PMN2
    b		RRet
RdPMN3:
    mrc     	p14, 0, r0, c3, c2, 0		@ Read PMN3
    b		RRet
RdINTEN:  
    mrc     	p14, 0, r0, c4, c1, 0		@ Read INTEN
    b		RRet
RdFLAG:
    mrc     	p14, 0, r0, c5, c1, 0		@ Read FLAG
    b		RRet
RdEVTSEL:  
    mrc     	p14, 0, r0, c8, c1, 0		@ Read EVTSEL

RRet:
    mov  	pc, lr          @ return

/*
@
@ pmu_reg_write - Writes to the PMU Register
@
@ Description:
@ 	This routine writes to the designated PMU register via CoProcesser 14.
@
@ Input Parameters:   
@       r0 - arg1 - PMU register number to write
@       r1 - arg2 - Value to write to PMU register
@
@	if r0 contains:
@		0 -> PMNC,  PMU Control Register
@		1 -> CCNT,  PMU Clock Counter
@		2 -> PMN0,  PMU Count Register 0
@		3 -> PMN1,  PMU Count Register 1
@		4 -> PMN2,	PMU Count Register 2
@		5 -> PMN3,  PMU Count Register 3
@		6 -> INTEN, PMU Interupt Enable Register
@		7 -> FLAG,  PMU Overflow Flag Status Register
@		8 -> EVTSEL	PMU Event Select Register
@
@ Returns:
@	None
@
@ Registers Modified:
@	CoProcessor Register Modified: PMU Register
@	General Purpose Registers Modified: None
@
@ NOTE   
@	Error checking not included
@
*/
.global pmu_reg_write;
.align 0;
pmu_reg_write:
    cmp     	r0, #8
    addls	pc, pc, r0, lsl #2
    b		WRet
    b		WrPMNC
    b		WrCCNT
    b		WrPMN0
    b		WrPMN1
    b		WrPMN2
    b		WrPMN3
    b		WrINTEN
    b		WrFLAG
    b		WrEVTSEL

WrPMNC:  
    mcr     	p14, 0, r1, c0, c1, 0		@ Write PMNC
    b		WRet
WrCCNT: 
    mcr     	p14, 0, r1, c1, c1, 0		@ Write CCNT
    b		WRet
WrPMN0: 
    mcr     	p14, 0, r1, c0, c2, 0		@ Write PMN0
    b		WRet
WrPMN1: 
    mcr     	p14, 0, r1, c1, c2, 0		@ Write PMN1
    b		WRet
WrPMN2:  
    mcr     	p14, 0, r1, c2, c2, 0		@ Write PMN2
    b		WRet
WrPMN3:  
    mcr     	p14, 0, r1, c3, c2, 0		@ Write PMN3
    b		WRet
WrINTEN:  
    mcr     	p14, 0, r1, c4, c1, 0		@ Write INTEN
    b		WRet
WrFLAG:
    mcr     	p14, 0, r1, c5, c1, 0		@ Write FLAG
    b		WRet
WrEVTSEL:  
    mcr     	p14, 0, r1, c8, c1, 0		@ Write EVTSEL
	
WRet:
    mov  	pc, lr          @ return
    
/*
; XSC1GetCPUId - Get the CPU ID from CP15 R0 Register
;
; This routine reads R0 from CoProcesser 15 to get the CPU ID
;
;       Uses r0 - return value of CPU ID
*/
.global XSC1GetCPUId;
.align 0;
XSC1GetCPUId:
    mrc     p15, 0, r0, c0, c0, 0
    mov  pc, lr
	 
.end 
