/*
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
#include <rk/rk.h>

/* 
 * CSS for cpu & disk access.
 * Assume that the application does some computation then access 
 * the disk and does some computation after the disk access.
 * This task model can be changed later.
 */
struct css_disk_cpu_reserve_attr {
  struct timespec compute_bf; /* CPU needed before the disk access */
  struct timespec compute_af; /* CPU needed after the disk access */
  unsigned long size;         /* file size needed to access */
  struct timespec period;
  struct timespec deadline;
  struct timespec blocking_time;
  struct timespec start_time;
  rk_reserve_param_data_t reserve_type;
};

typedef struct css_disk_cpu_reserve_attr css_disk_cpu_reserve_attr_data_t;
typedef struct css_disk_cpu_reserve_attr *css_disk_cpu_reserve_attr_t;

/* the disk parameter needed for CSS decision */
struct disk_param {
  cpu_tick_data_t invoke_ticks; /* kernel overhead to invoke a request */
  cpu_tick_data_t return_ticks; /* kernel overhead to return data back */
  cpu_tick_data_t one_block_ticks; /* kernel and I/O overhead for one block access */
  cpu_tick_data_t read_ahead_ticks; /* kernel overhead to issue one readahead request */
  cpu_tick_data_t user_copy_ticks; /* user overhead to get one block of data to kernel memory */
  unsigned long blocksize;    /* in Kbytes */
  unsigned long max_readahead; /* in bytes */
  cpu_tick_data_t server_period_ticks; 
};

typedef struct disk_param disk_param_data_t;
typedef struct disk_param *disk_param_t;

extern int css_disk_cpu_reserve_create(rk_resource_set_t, 
				       css_disk_cpu_reserve_attr_t);
