#
# Makefile for Spectrum24t
#

include ../config.mk

LIB := ../lib

OBJS = Spectrum24tSw.o Spectrum24tHw.o  Spectrum24tDnld.o
SRCS = Spectrum24tSw.c SpectrumtHw.c  Spectrum24tDnld.c

CFLAGS = -O3 -Wall -Wstrict-prototypes -pipe
CPPFLAGS += $(PCDEBUG) -D__KERNEL__ -DMODULE   
CC = $(KCC) $(AFLAGS) $(KFLAGS)


all: spectrum24t_cs.o

spectrum24t_cs.o: $(OBJS)
	$(LD) -r -o $@ $(OBJS) -L$(LIB) 
	chmod -x $@

Spectrum24tDnld.c: Spectrum24tPrim.h Spectrum24tSec.h

Spectrum24tPrim.h: EPRIMSYM.BIN bin_to_h
	./bin_to_h EPRIMSYM.BIN primsym > Spectrum24tPrim.h

Spectrum24tSec.h: ESECSYM.BIN bin_to_h
	./bin_to_h ESECSYM.BIN secsym > Spectrum24tSec.h

bin_to_h: bin_to_h.c
	gcc -o bin_to_h bin_to_h.c

include ../rules.mk
