/*
 * linux/arch/arm/mach-sa1100/jornada56x.c
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/delay.h>

#include <asm/hardware.h>
#include <asm/arch/irqs.h>
#include <asm/setup.h>

#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/serial_sa1100.h>
#include <linux/sched.h>
#include <linux/serial_core.h>

#include "generic.h"
#include "sa1111.h"
#include <asm/hardware/sa1111.h>

#include <linux/wait.h>          /* for wait_queue_head_t, used in h3600_ts.h */
#include <linux/types.h>         /* for u_char, used in h3600_ts.h */
#include <linux/h3600_ts.h>      /* for TS_RET */

void jornada_contrast(int arg_contrast)
{
}

int jornada_brightness(int arg_brightness)
{
	int i = 0;

        if (arg_brightness) {
        } else {
        }
	return i;
}

void jornada56x_battery(void)
{
}

int jornada56x_getkey(unsigned char *data, int size)
{
	int this_count = 0, i, j;

	return this_count;
}

int jornada56x_gettouch(int *arg_x, int *arg_y)
{
	int this_return = 0;

	return this_return;
}

#define PCR_GET_VALUE		0x00000000
#define PCR_SET_VALUE		0x00000001
#define PCR_BIT_SET			0x00000002
#define PCR_BIT_CLEAR		0x00000004
#define TOP_MASK			0x0000ff80
#define BOTTOM_MASK			0x0000003f

void SetPMUPCRRegister(long dwAction, long dwValue)
{
	struct pmureg *pmuregbase = (struct pmureg *)PMU_REAL_BASE;
	long PCRReg;
	long topbits, bottombits;
	
	//Read PCR and remove the unwanted bit 6
	bottombits = (pmuregbase->pcr & BOTTOM_MASK);
	topbits = (pmuregbase->pcr & TOP_MASK);
	PCRReg = ((topbits >>1) | bottombits);

	PCRReg &= ~(MUX_CLK0|MUX_CLK1); 
	if (PCRReg & SM_CLK_En)
		PCRReg |= MUX_CLK1;
	else if (PCRReg & MMC_CLK_En)
		PCRReg |= MUX_CLK0; 
	switch (dwAction) {
		case PCR_SET_VALUE:
			PCRReg = dwValue;
			break;
		case PCR_BIT_SET:
			if(dwValue & SM_CLK_En) {// smart card controller is to be enabled
				PCRReg &= ~(MUX_CLK0|MUX_CLK1);
				PCRReg |= MUX_CLK1;
			}
			else if(dwValue & MMC_CLK_En) { // mmc controller is to be enabled
				PCRReg &= ~(MUX_CLK0|MUX_CLK1); 
				PCRReg |= MUX_CLK0;
			}			
			PCRReg |= dwValue;
			break;
		case PCR_BIT_CLEAR:
			// smart card or mmc controller is to be disabled
			if (dwValue & (SM_CLK_En|MMC_CLK_En))
				PCRReg &= ~(MUX_CLK0|MUX_CLK1);
			PCRReg &= ~dwValue;
			break;
		case PCR_GET_VALUE:
		default:
			break;
	}
	pmuregbase->pcr = PCRReg;	
}

static int __init jornada56x_init(void)
{
 	struct pmureg *pmuregbase = (struct pmureg *)PMU_REAL_BASE;
	struct egpioreg *egpioregbase = (struct egpioreg *)E_GPIO_REAL_BASE;

	GPSR = 0x00100000;
	GPCR = 0x0f424000;
	GAFR = 0x080803fc;
	//GRER = 0x00448c00;
	//GFER = 0x00448800;
	GPDR = 0x0f5243fc;
	//PPAR = 0;
	//PPDR = 0;
	//PPSR = 0;
	udelay(1);

	GPCR = GPIO_GPIO20;		// Toggle the Reset pin
	udelay(1);
	GPSR = GPIO_GPIO20;

	// Initialise the PMU register
  	pmuregbase->gpioafr = 0x02;
  	pmuregbase->scr = RCLK_En;      // Enable the internal system reference clock for ASIC

	// Read more on SetPMUPCRRegister function on the next section
	// It is better to turn on the GPIO int clock here,
	// the PWM clock is for adjusting the brightness of the display
  	SetPMUPCRRegister(PCR_BIT_SET,(GPIO_INT_CLK_En|PWM1CLK_En));

	pmuregbase->pwm1_ckdr = 0;
	pmuregbase->pwm2_ckdr = 0;

	// Initialise the GPIO register
  	egpioregbase->gpbpdr = 0x01FF;
  	egpioregbase->gpcpdr = 0x37C2;
  	egpioregbase->gpdpdr = 0xFFFF;
  	
  	egpioregbase->gpbpsr = 0x001B;
  	egpioregbase->gpcpsr = 0x31C0;
  	egpioregbase->gpdpsr = 0xAD99;
  	
  	egpioregbase->gpbpcr = 0x3E24;
  	egpioregbase->gpcpcr = 0x0002;
  	egpioregbase->gpdpcr = 0x5266;

  	egpioregbase->gpbpsdr = 0x81FF;
  	egpioregbase->gpcpsdr = 0xB96F;
  	egpioregbase->gpdpsdr = 0xFBFF;
  	
  	egpioregbase->gpbpslr = 0x00D0;
  	egpioregbase->gpcpslr = 0x0000;
  	egpioregbase->gpdpslr = 0xA198;
  	
  	egpioregbase->gpbpfdr = 0x81FF;
  	egpioregbase->gpcpfdr = 0xB96F;
  	egpioregbase->gpdpfdr = 0xFBFF;
  	
  	egpioregbase->gpbpflr = 0x01D0;
  	egpioregbase->gpcpflr = 0x0000;
  	egpioregbase->gpdpflr = 0xA198;

	// Clear screen here
	egpioregbase->gpdpsr = GPIO_GPIO15; // Turn off the front light
	egpioregbase->gpdpcr = GPIO_GPIO5;
	egpioregbase->gpdpcr = GPIO_GPIO13;   // Turn on power to panel
	mdelay(2);	// Delay 2 milliseconds.

	return 0;
}

__initcall(jornada56x_init);

static void __init
fixup_jornada56x(struct machine_desc *desc, struct param_struct *params,
		 char **cmdline, struct meminfo *mi)
{
}

static struct map_desc jornada56x_io_desc[] __initdata = {
        /* virtual     physical    length      domain     r  w  c  b */
        { 0xe8000000, 0x00000000, 0x02000000, DOMAIN_IO, 1, 1, 0, 0 }, /* Flash bank 0 */
        { 0xf0000000, 0x40000000, 0x00100000, DOMAIN_IO, 1, 1, 0, 0 }, /* ASIC */
        LAST_DESC
};

static void __init jornada56x_map_io(void)
{
	sa1100_map_io();
	iotable_init(jornada56x_io_desc);

	sa1100_register_uart(0, 3);
	sa1100_register_uart(1, 1);
}

MACHINE_START(JORNADA56X, "HP Jornada 56x")
BOOT_MEM(0xc0000000, 0x80000000, 0xf8000000)
BOOT_PARAMS(0xc0000100)
FIXUP(fixup_jornada56x)
MAPIO(jornada56x_map_io)
INITIRQ(sa1100_init_irq)
MACHINE_END
