/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    private ZipEntry current;
    private ZipEntry chain;
    private int method;
    private int level;
    private String comment;
    private long bytes_written;
    private int uncompressed_size;
    private Checksum sum;

    private /* synthetic */ void finit$() {
        this.method = 8;
        this.level = -1;
        this.comment = "";
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void closeEntry() throws IOException {
        int compressed_size;
        if (this.current.method == 0) {
            compressed_size = this.uncompressed_size;
        } else {
            super.finish();
            compressed_size = this.def.getTotalOut();
        }
        long crc = this.sum.getValue();
        this.bytes_written += (long)compressed_size;
        if (this.current.getCrc() == (long)-1 || this.current.getCompressedSize() == (long)-1 || this.current.getSize() == (long)-1) {
            this.current.setCrc(crc);
            this.current.compressedSize = compressed_size;
            this.current.setSize(this.uncompressed_size);
            this.put4(134695760);
            this.put4((int)this.current.getCrc());
            this.put4((int)this.current.getCompressedSize());
            this.put4((int)this.current.getSize());
            this.bytes_written += (long)16;
        } else if (this.current.getCrc() != crc || this.current.getCompressedSize() != (long)compressed_size || this.current.getSize() != (long)this.uncompressed_size) {
            throw new ZipException("zip entry field incorrect");
        }
        this.current.next = this.chain;
        this.chain = this.current;
        this.current = null;
    }

    public void write(int bval) throws IOException {
        if (this.current.method == 0) {
            this.out.write(bval);
        } else {
            super.write(bval);
        }
        this.sum.update(bval);
        ++this.uncompressed_size;
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (this.current.method == 0) {
            this.out.write(buf, off, len);
        } else {
            super.write(buf, off, len);
        }
        this.sum.update(buf, off, len);
        this.uncompressed_size += len;
    }

    public void finish() throws IOException {
        if (this.current != null) {
            this.closeEntry();
        }
        long offset = this.bytes_written;
        int count = 0;
        int bytes = 0;
        while (this.chain != null) {
            bytes += this.write_entry(this.chain, false);
            ++count;
            this.chain = this.chain.next;
        }
        this.put4(101010256);
        this.put2(0);
        this.put2(0);
        this.put2(count);
        this.put2(count);
        this.put4(bytes);
        this.put4((int)offset);
        byte[] c = this.comment.getBytes("8859_1");
        this.put2(c.length);
        this.out.write(c);
    }

    private int write_entry(ZipEntry entry, boolean is_local) throws IOException {
        int bytes = this.put4(is_local ? 67324752 : 33639248);
        if (!is_local) {
            bytes += this.put_version();
        }
        bytes += this.put_version();
        boolean crc_after = false;
        if (is_local && (entry.getCrc() == (long)-1 || entry.getCompressedSize() == (long)-1 || entry.getSize() == (long)-1)) {
            crc_after = true;
        }
        bytes += this.put2(crc_after ? 8 : 0);
        bytes += this.put2(entry.method);
        bytes += this.put2(0);
        bytes += this.put2(0);
        if (crc_after) {
            bytes += this.put4(0);
            bytes += this.put4(0);
            bytes += this.put4(0);
        } else {
            bytes += this.put4((int)entry.getCrc());
            bytes += this.put4((int)entry.getCompressedSize());
            bytes += this.put4((int)entry.getSize());
        }
        byte[] name = entry.name.getBytes("8859_1");
        bytes += this.put2(name.length);
        bytes += this.put2(entry.extra == null ? 0 : entry.extra.length);
        byte[] comment = null;
        if (!is_local) {
            if (entry.getComment() == null) {
                bytes += this.put2(0);
            } else {
                comment = entry.getComment().getBytes("8859_1");
                bytes += this.put2(comment.length);
            }
            bytes += this.put2(0);
            bytes += this.put2(0);
            bytes += this.put4(0);
            bytes += this.put4((int)entry.relativeOffset);
        }
        this.out.write(name);
        bytes += name.length;
        if (entry.extra != null) {
            this.out.write(entry.extra);
            bytes += entry.extra.length;
        }
        if (comment != null) {
            this.out.write(comment);
            bytes += comment.length;
        }
        this.bytes_written += (long)bytes;
        return bytes;
    }

    public void putNextEntry(ZipEntry entry) throws IOException {
        if (this.current != null) {
            this.closeEntry();
        }
        if (entry.method < 0) {
            entry.method = this.method;
        }
        if (entry.method == 0) {
            if (entry.getSize() == (long)-1 || entry.getCrc() == (long)-1) {
                throw new ZipException("required entry not set");
            }
            entry.compressedSize = entry.getSize();
        }
        entry.relativeOffset = this.bytes_written;
        this.write_entry(entry, true);
        this.current = entry;
        int compr = this.method == 0 ? 0 : this.level;
        this.def.reset();
        this.def.setLevel(compr);
        this.sum.reset();
        this.uncompressed_size = 0;
    }

    public void setLevel(int level) {
        if (level != -1 && (level < 0 || level > 9)) {
            throw new IllegalArgumentException();
        }
        this.level = level;
    }

    public void setMethod(int method) {
        if (method != 8 && method != 0) {
            throw new IllegalArgumentException();
        }
        this.method = method;
    }

    public void setComment(String comment) {
        if (comment.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    public ZipOutputStream(OutputStream out) {
        super(out, new Deflater(-1, true), 8192);
        this.finit$();
        this.sum = new CRC32();
    }

    private int put2(int i) throws IOException {
        this.out.write(i);
        this.out.write(i >> 8);
        return 2;
    }

    private int put4(int i) throws IOException {
        this.out.write(i);
        this.out.write(i >> 8);
        this.out.write(i >> 16);
        this.out.write(i >> 24);
        return 4;
    }

    private int put_version() throws IOException {
        return this.put2(768);
    }
}

