/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactory {
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFacSpi, Provider provider, String algorithm) {
        this.keyFacSpi = keyFacSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public static KeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String classname = p[i].getProperty("KeyFactory." + algorithm);
            if (classname == null) continue;
            return KeyFactory.getInstance(classname, algorithm, p[i]);
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static KeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return KeyFactory.getInstance(p.getProperty("KeyFactory." + algorithm), algorithm, p);
    }

    private static KeyFactory getInstance(String classname, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new KeyFactory((KeyFactorySpi)Class.forName(classname).newInstance(), provider, algorithm);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoSuchAlgorithmException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new NoSuchAlgorithmException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchAlgorithmException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final KeySpec getKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, keySpec);
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(key);
    }
}

