/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable {
    static final long serialVersionUID = 7515723908773894738L;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('S');
    private final short value;

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) throws NumberFormatException {
        this.value = Short.parseShort(s, 10);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Short && ((Short)obj).value == this.value;
    }

    public static String toString(short i) {
        return Integer.toString(i);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return new Short(Short.parseShort(s));
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return new Short(Short.parseShort(s, radix));
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    public static Short decode(String s) throws NumberFormatException {
        int i = Integer.decode(s);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return new Short((short)i);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Short s) {
        return this.value - s.value;
    }

    public int compareTo(Object o) {
        return this.compareTo((Short)o);
    }
}

