/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class InheritableThreadLocal
extends ThreadLocal {
    private static Map threadMap = new WeakHashMap();

    protected Object childValue(Object parentValue) {
        return parentValue;
    }

    public Object get() {
        this.addToHeritage();
        return super.get();
    }

    public void set(Object value) {
        this.addToHeritage();
        super.set(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void addToHeritage() {
        Set heritage;
        block6: {
            Thread currentThread = Thread.currentThread();
            Map map = threadMap;
            // MONITORENTER : map
            try {
                heritage = (Set)threadMap.get(currentThread);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                // MONITOREXIT : map
                throw throwable;
            }
            Object var4_4 = null;
            // MONITOREXIT : map
            if (heritage != null) break block6;
            heritage = new HashSet();
            Map map2 = threadMap;
            // MONITORENTER : map2
            try {
                threadMap.put(currentThread, heritage);
            }
            catch (Throwable throwable) {
                var4_4 = null;
                // MONITOREXIT : map2
                throw throwable;
            }
            var4_4 = null;
            // MONITOREXIT : map2
        }
        if (heritage.contains(this)) return;
        heritage.add(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void newChildThread(Thread childThread) {
        Thread parentThread = Thread.currentThread();
        Map map = threadMap;
        synchronized (map) {
            Object var4_4;
            Set heritage;
            try {
                heritage = (Set)threadMap.get(parentThread);
            }
            finally {
                var4_4 = null;
            }
            if (heritage == null) return;
            Map map2 = threadMap;
            synchronized (map2) {
                try {
                    threadMap.put(childThread, new HashSet(heritage));
                }
                finally {
                    var4_4 = null;
                }
                Iterator it = heritage.iterator();
                while (it.hasNext()) {
                    InheritableThreadLocal local = (InheritableThreadLocal)it.next();
                    Object parentValue = local.get(parentThread).getValue();
                    Object childValue = local.childValue(parentValue);
                    ThreadLocal.Value v = new ThreadLocal.Value(childValue);
                    local.set(childThread, v);
                }
                return;
            }
        }
    }
}

