/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('B');
    private final byte value;

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) throws NumberFormatException {
        this.value = Byte.parseByte(s, 10);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Byte && this.value == (Byte)obj;
    }

    public static String toString(byte i) {
        return Integer.toString(i);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static Byte valueOf(String s) throws NumberFormatException {
        return new Byte(Byte.parseByte(s));
    }

    public static Byte valueOf(String s, int radix) throws NumberFormatException {
        return new Byte(Byte.parseByte(s, radix));
    }

    public static byte parseByte(String s) throws NumberFormatException {
        return Byte.parseByte(s, 10);
    }

    public static byte parseByte(String str, int radix) throws NumberFormatException {
        int i = Integer.parseInt(str, radix);
        if (i < -128 || i > 127) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    public static Byte decode(String str) throws NumberFormatException {
        int i = Integer.decode(str);
        if (i < -128 || i > 127) {
            throw new NumberFormatException();
        }
        return new Byte((byte)i);
    }

    public byte byteValue() {
        return this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Byte b) {
        return this.value - b;
    }

    public int compareTo(Object o) {
        return this.compareTo((Byte)o);
    }
}

