/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

public class PipedInputStream
extends InputStream {
    PipedOutputStream source;
    boolean closed;
    protected static final int PIPE_SIZE = 2048;
    protected byte[] buffer;
    protected int in;
    protected int out;
    private byte[] read_buf;

    private /* synthetic */ void finit$() {
        this.buffer = new byte[2048];
        this.in = -1;
        this.out = 0;
        this.read_buf = new byte[1];
    }

    public PipedInputStream() {
        this.finit$();
    }

    public PipedInputStream(PipedOutputStream source) throws IOException {
        this.finit$();
        this.connect(source);
    }

    public void connect(PipedOutputStream source) throws IOException {
        if (this.source != null || source.sink != null) {
            throw new IOException("Already connected");
        }
        source.sink = this;
        this.source = source;
    }

    protected synchronized void receive(int b) throws IOException {
        this.read_buf[0] = (byte)b & 0xFFFFFFFF;
        this.receive(this.read_buf, 0, 1);
    }

    synchronized void receive(byte[] buf, int offset, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        int bufpos = offset;
        while (len > 0) {
            try {
                while (this.in == this.out) {
                    this.notifyAll();
                    this.wait();
                    if (!this.closed) continue;
                    throw new IOException("Pipe closed");
                }
            }
            catch (InterruptedException ix) {
                throw new InterruptedIOException();
            }
            if (this.in < 0) {
                this.in = 0;
            }
            int copylen = this.in < this.out ? Math.min(len, this.out - this.in) : Math.min(len, this.buffer.length - this.in);
            System.arraycopy(buf, bufpos, this.buffer, this.in, copylen);
            len -= copylen;
            bufpos += copylen;
            this.in += copylen;
            if (this.in != this.buffer.length) continue;
            this.in = 0;
        }
        this.notifyAll();
    }

    public int read() throws IOException {
        int r = this.read(this.read_buf, 0, 1);
        if (r == -1) {
            return -1;
        }
        return this.read_buf[0];
    }

    public synchronized int read(byte[] buf, int offset, int len) throws IOException {
        if (this.source == null) {
            throw new IOException("Not connected");
        }
        if (this.closed) {
            throw new IOException("Pipe closed");
        }
        try {
            while (this.in < 0) {
                if (this.source.closed) {
                    return -1;
                }
                this.wait();
            }
        }
        catch (InterruptedException ix) {
            throw new InterruptedIOException();
        }
        int total = 0;
        do {
            int copylen = this.out < this.in ? Math.min(len, this.in - this.out) : Math.min(len, this.buffer.length - this.out);
            System.arraycopy(this.buffer, this.out, buf, offset, copylen);
            offset += copylen;
            len -= copylen;
            this.out += copylen;
            total += copylen;
            if (this.out == this.buffer.length) {
                this.out = 0;
            }
            if (this.out != this.in) continue;
            this.in = -1;
            this.out = 0;
        } while (len != 0 && this.in != -1);
        this.notifyAll();
        return total;
    }

    public synchronized int available() throws IOException {
        if (this.in < 0) {
            return 0;
        }
        if (this.out < this.in) {
            return this.in - this.out;
        }
        return this.buffer.length - this.out + this.in;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.notifyAll();
    }
}

