/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRemoteCall;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;
import java.rmi.server.UnicastRemoteObject;

public class UnicastRef
implements RemoteRef,
ProtocolConstants {
    public ObjID objid;
    UnicastConnectionManager manager;

    private UnicastRef() {
    }

    public UnicastRef(ObjID objid, String host, int port, RMIClientSocketFactory csf) {
        this(objid);
        this.manager = UnicastConnectionManager.getInstance(host, port, csf);
    }

    public UnicastRef(ObjID objid) {
        this.objid = objid;
    }

    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        return this.invokeCommon(obj, method, params, -1, opnum);
    }

    private Object invokeCommon(Remote obj, Method method, Object[] params, int opnum, long hash) throws Exception {
        Object returnval;
        int returncode;
        UnicastConnection conn;
        try {
            conn = this.manager.getConnection();
        }
        catch (IOException e1) {
            throw new RemoteException("connection failed to host: " + this.manager.serverName, e1);
        }
        try {
            DataOutputStream dout = conn.getDataOutputStream();
            dout.writeByte(80);
            ObjectOutputStream out = conn.getObjectOutputStream();
            this.objid.write(out);
            out.writeInt(opnum);
            out.writeLong(hash);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] instanceof UnicastRemoteObject) {
                        out.writeObject(UnicastRemoteObject.exportObject((UnicastRemoteObject)params[i]));
                        continue;
                    }
                    out.writeObject(params[i]);
                }
            }
            out.flush();
        }
        catch (IOException e2) {
            throw new RemoteException("call failed: ", e2);
        }
        try {
            DataInputStream din = conn.getDataInputStream();
            if (din.readUnsignedByte() != 81) {
                throw new RemoteException("Call not acked");
            }
            ObjectInputStream in = conn.getObjectInputStream();
            returncode = in.readUnsignedByte();
            UID ack = UID.read(in);
            returnval = in.readObject();
        }
        catch (IOException e3) {
            throw new RemoteException("call return failed: ", e3);
        }
        this.manager.discardConnection(conn);
        if (returncode != 1) {
            throw (Exception)returnval;
        }
        return returnval;
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] op, int opnum, long hash) throws RemoteException {
        return new UnicastRemoteCall(obj, opnum, hash);
    }

    public void invoke(RemoteCall call) throws Exception {
        UnicastRemoteCall c = (UnicastRemoteCall)call;
        Object ret = this.invokeCommon((Remote)c.getObject(), null, c.getArguments(), c.getOpnum(), c.getHash());
        c.setReturnValue(ret);
    }

    public void done(RemoteCall call) throws RemoteException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.manager == null) {
            throw new IOException("no connection");
        }
        this.manager.write(out);
        this.objid.write(out);
        out.writeByte(1);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.manager = UnicastConnectionManager.read(in);
        this.objid = ObjID.read(in);
        if (in.readByte() != 1) {
            throw new IOException("no ack found");
        }
    }

    public boolean remoteEquals(RemoteRef ref) {
        throw new Error("Not implemented");
    }

    public int remoteHashCode() {
        throw new Error("Not implemented");
    }

    public String getRefClass(ObjectOutput out) {
        return "UnicastRef";
    }

    public String remoteToString() {
        throw new Error("Not implemented");
    }

    public void dump(UnicastConnection conn) {
        try {
            DataInputStream din = conn.getDataInputStream();
            while (true) {
                int b = din.readUnsignedByte();
                System.out.print(Integer.toHexString(b));
                if (b >= 32 && b < 128) {
                    System.out.print(": " + (char)b);
                }
                System.out.println();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }
}

