/*
 * ppc_timer.c: PowerPC high resolution timer support (not yet working)
 *
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <linux/config.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <asm/timex.h>
#include <rk/rk_linux.h>
#include <rk/rk.h>

extern int debug;

/* Accessor functions for the decrementer register. */
static __inline__ unsigned int get_dec(void)
{
    unsigned int ret;

    asm volatile ("mfspr %0,22":"=r" (ret):);
    return ret;
}

static __inline__ void set_dec(unsigned int val)
{
    asm volatile ("mtspr 22,%0"::"r" (val));
}

char *tmrtype[] = {
    "TMR_NULL",
    "TMR_REPLENISH_RSV",	/* used for replenishing reserves  */
    "TMR_PERIOD_START",		/* a periodic process's start time */
    "TMR_NEXT_PERIOD",		/* periodic timer for processes    */
    "TMR_POSIX",		/* used for POSIX timers */
    "TMR_JIFFY",		/* Linux timer interrupt */
    "TMR_ENFORCE"		/* used for enforcement of CPU reserves */
};

/* Set the decrementer to go off when the first timer expires */
void rk_update_hw_timer(struct rk_timer *tmr)
{
    cpu_tick_data_t now;
    unsigned int val;

    rk_rdtsc(&now);
    val = tmr->tmr_expire - now;

    if (tmr->tmr_expire <= now)
	val = 1;		/* already expired, minimum delay of 1 tick imposed */

    set_dec(val);
    if (val > rk_cpu_ticks_per_second / HZ)
	printk("No jiffies?\n");
}

extern int rk_has_timer;

void rk_hw_timer_set_periodic(void)
{
    rk_has_timer = 0;
}

void wake_up_process(struct task_struct *ts)
{
}
