/*
 * linux/include/asm-arm/arch-adifcc/uncompress.h
 *
 * Author: Deepak Saxena <dsaxena@mvista.com>
 *
 * Copyright (c) 2001 MontaVista Software, Inc.
 *
 */

#ifndef _ARCH_UNCOMPRESS_H_
#define _ARCH_UNCOMPRESS_H_

#ifdef CONFIG_ARCH_ADI_EVB
#define UART_BASE    ((volatile unsigned char *)0x00400000)
#elif defined(CONFIG_ARCH_BRH)
#define UART_BASE    ((volatile unsigned char *)0x03000000)
#define UART_BASE2    ((volatile unsigned char *)0x03100000)
#endif


static __inline__ void putc(char c)
{
	/*
	 * Boards have peripherals wired in LE mode, so need to
	 * fiddle with the address to get the proper byte lane
	 * enabled. :)
	 */
#if defined(__ARMEB__) && defined(_FOOBAR_)
	while ((UART_BASE[6] & 0x60) != 0x60);
	UART_BASE[3] = c;
#else

	while ((UART_BASE[5] & 0x60) != 0x60);
	UART_BASE[0] = c;
#endif
}

/*
 * This does not append a newline
 */
static void puts(const char *s)
{
	while (*s) {
		putc(*s);
		if (*s == '\n')
			putc('\r');
		s++;
	}
}

#ifdef CONFIG_ARCH_BRH

#include <linux/serial_reg.h>

static void arch_decomp_setup()
{
	UART_BASE[UART_LCR] = 0x36;
	UART_BASE[UART_DLL] = 36;
	UART_BASE[UART_DLM] = 0;
	UART_BASE[UART_LCR] = 0x3;
	UART_BASE[UART_MCR] = 0;
	UART_BASE[UART_FCR] = 0x6;
	UART_BASE[UART_IER] = 0;
}

#else
#define arch_decomp_setup()
#endif

#define arch_decomp_wdog()


#endif // _ARCH_UNCOMPRESS_H_
