/*
 * Copyright (C) Carnegie Mellon University
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#define ENERGY_AWARE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <signal.h>


void print_usage(char *cmdname)
{
    printf("Usage: %s <policy>\n", cmdname);
    printf("NODVS     - policy 0\n");
    printf("SYS_CLOCK - policy 1 \n");
    printf("PM_CLOCK  - policy 2 \n");
}

int main(int argc, char *argv[])
{

    if (argc != 2) {
	print_usage(argv[0]);
	return -1;
    }

    rk_cpu_energy_aware_set_policy(atoi(argv[1]));
    return 0;
}
