/* 
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <rk/rk.h>
#include <rk/rk_error.h>
#include <signal.h>

rk_resource_set_t rs1, rs2, rs3;

#define C1 20 
#define T1 100
#define C2 30
#define T2 150
#define C3 150
#define T3 300

int main(int argc, char *argv[])
{

    rk_reserve_t cpu_rsv1, cpu_rsv2, cpu_rsv3;
    rk_reserve_param_data_t p;
    cpu_reserve_attr_data_t attr;
    struct timespec c, t;

    /* create resource set */
    {
        rs1 = rk_resource_set_create("");

	c.tv_sec = C1/1000; c.tv_nsec = C1 * 1000000;
	t.tv_sec = T1/1000; t.tv_nsec = T1 * 1000000;
	p.enf_mode = RSV_HARD;	/* enum in rk.h -> check =0x1 */
	p.sch_mode = p.rep_mode = RSV_HARD;
	attr.compute_time = c;
	attr.period = t;
	attr.deadline = t;
	attr.blocking_time.tv_sec = 0;
	attr.blocking_time.tv_nsec = 0;
	attr.start_time.tv_sec = 0;
	attr.start_time.tv_nsec = 0;
	attr.reserve_type = p;

	if ((cpu_rsv1 = rk_cpu_reserve_create(rs1, &attr)) == NULL) {
	    fprintf(stderr,
		    "%s: could not create cpu reserve 1, quitting...\n",
		    argv[0]);
	    if (rk_resource_set_destroy(rs1) != RK_SUCCESS) {
		fprintf(stderr, "%s: could not destroy rset %p either!\n",
			argv[0], rs1);
	    }
	    exit(-1);
	}
    }

    {
        rs2 = rk_resource_set_create("");

	c.tv_sec = C2/1000; c.tv_nsec = C2 * 1000000;
	t.tv_sec = T2/1000; t.tv_nsec = T2 * 1000000;
	p.enf_mode = RSV_HARD;	/* enum in rk.h -> check =0x1 */
	p.sch_mode = p.rep_mode = RSV_HARD;
	attr.compute_time = c;
	attr.period = t;
	attr.deadline = t;
	attr.blocking_time.tv_sec = 0;
	attr.blocking_time.tv_nsec = 0;
	attr.start_time.tv_sec = 0;
	attr.start_time.tv_nsec = 0;
	attr.reserve_type = p;

	if ((cpu_rsv2 = rk_cpu_reserve_create(rs2, &attr)) == NULL) {
	    fprintf(stderr,
		    "%s: could not create cpu reserve 2, quitting...\n",
		    argv[0]);
	    if (rk_resource_set_destroy(rs1) != RK_SUCCESS) {
		fprintf(stderr, "%s: could not destroy rset %p either!\n",
			argv[0], rs1);
	    }
	    if (rk_resource_set_destroy(rs2) != RK_SUCCESS) {
		fprintf(stderr, "%s: could not destroy rset %p either!\n",
			argv[0], rs2);
	    }
	    exit(-1);
	}
    }

    {
        rs3 = rk_resource_set_create("");

	c.tv_sec = C3/1000; c.tv_nsec = C3 * 1000000;
	t.tv_sec = T3/1000; t.tv_nsec = T3 * 1000000;
	p.enf_mode = RSV_HARD;	/* enum in rk.h -> check =0x1 */
	p.sch_mode = p.rep_mode = RSV_HARD;
	attr.compute_time = c;
	attr.period = t;
	attr.deadline = t;
	attr.blocking_time.tv_sec = 0;
	attr.blocking_time.tv_nsec = 0;
	attr.start_time.tv_sec = 0;
	attr.start_time.tv_nsec = 0;
	attr.reserve_type = p;

	if ((cpu_rsv3 = rk_cpu_reserve_create(rs3, &attr)) == NULL) {
	    fprintf(stderr,
		    "%s: could not create cpu reserve 3, quitting...\n",
		    argv[0]);
	    if (rk_resource_set_destroy(rs1) != RK_SUCCESS) {
		fprintf(stderr, "%s: could not destroy rset %p either!\n",
			argv[0], rs1);
	    }
	    if (rk_resource_set_destroy(rs2) != RK_SUCCESS) {
		fprintf(stderr, "%s: could not destroy rset %p either!\n",
			argv[0], rs2);
	    }
	    if (rk_resource_set_destroy(rs3) != RK_SUCCESS) {
		fprintf(stderr, "%s: could not destroy rset %p either!\n",
			argv[0], rs3);
	    }
	    exit(-1);
	}
    }


    printf("Resource Set 1 (0x%x)=(%d) CPU Reserve (0x%x)\n", (int) rs1,
	   (int) rs1, (int) cpu_rsv1);
    printf("Resource Set 2 (0x%x)=(%d) CPU Reserve (0x%x)\n", (int) rs2,
	   (int) rs2, (int) cpu_rsv2);
    printf("Resource Set 3 (0x%x)=(%d) CPU Reserve (0x%x)\n", (int) rs3,
	   (int) rs3, (int) cpu_rsv3);

    return 0;
}
