/*
 * linux/arch/arm/kernel/brh-time.c
 *
 * This file implements a timer using the BRH board's external timer source 
 * using the 33.3 Mhz peripheral bus clock
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/time.h>
#include <linux/init.h>
#include <linux/smp.h>

#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/irq.h>

#include <linux/timex.h>
#include <asm/hardware.h>

extern int setup_arm_irq(int, struct irqaction *);

/* IRQs are disabled before entering here from do_gettimeofday() */
static unsigned long brh_gettimeoffset (void)
{
	unsigned long elapsed, usec;

	/* We need elapsed timer ticks since last interrupt */
	elapsed = LATCH - 1 - *BRH_TIMER0_VALUE;

	/* Now convert them to usec */
	usec = (unsigned long)(elapsed*tick)/LATCH;

	return usec;
}

static void brh_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
  do {
    *BRH_TIMER0_CTRL = *BRH_TIMER0_CTRL | BRH_TIMER_INTERRUPT; 
    do_timer(regs);
    
    *BRH_TIMER0_PRELOAD = LATCH-1;
    *BRH_TIMER0_CTRL = *BRH_TIMER0_CTRL | BRH_TIMER_INTERRUPT;
    *BRH_TIMER0_CTRL = *BRH_TIMER0_CTRL | BRH_TIMER_ENABLE;
    
  } while (*BRH_TIMER0_VALUE <= 0);
}

extern unsigned long (*gettimeoffset)(void);

/* CONFIG_RK */
//static 
struct irqaction timer_irq = {

	name: "timer",
	handler: brh_timer_interrupt,
	flags: SA_INTERRUPT
};

void __init setup_timer (void)
{
//    unsigned long INTSTR;

    gettimeoffset = brh_gettimeoffset;
    setup_arm_irq(IRQ_BRH_TIMERA, &timer_irq);
    
    printk("Using BRH External timer as timer source(IRQ %d, %d MHz Clock Tick)\n",
	   IRQ_BRH_TIMERA, CLOCK_TICK_RATE / 1000000 );
    
    *BRH_TIMER0_PRELOAD = 1;
    *BRH_TIMER0_CTRL = *BRH_TIMER0_CTRL | BRH_TIMER_INTERRUPT;
    *BRH_TIMER0_CTRL = *BRH_TIMER0_CTRL | BRH_TIMER_ENABLE;
}
