/* 
 * vscale.c: Voltage-Scaling Kernel Module for XScale BRH board
 * 
 * Author: Saowanee Saewong (ssaewong@cmu.edu)
 *
 * Real-Time and Multimedia Systems Laboratory                                  * Copyright (c) 2002 Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>

#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/types.h>
#include <asm/hardware.h>

#include "VSCALE_BRH.h"


int init_module(void)
{

  int i,j;

  /* Write to LED */
  printk("This is a kernel module to test voltage scaling on BRH \n");
  printk("Test LED \n");
  writeb(BRH_LED_HEX_4, BRH_LED_BASE);  
  /* Change the voltage scaling */
  printk("Change voltage to 1.00 v \n");
  writeb(BRH_VOLT_100V, BRH_VOLT_CONTROL);
  writeb(BRH_LED_HEX_0, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_1, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_2, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_3, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_4, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_5, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_6, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_7, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_8, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_9, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_A, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_B, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_C, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_D, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_E, BRH_LED_BASE);  
  writeb(BRH_LED_HEX_F, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_1, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_2, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_3, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_4, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_5, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_6, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_7, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_8, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_9, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_A, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_B, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_C, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_D, BRH_LED_BASE);  
  nop();
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_E, BRH_LED_BASE);  
  for (j= 0; j < 1000; j++) 
    for (i = 0; i < 10000; i++);
  writeb(BRH_LED_HEX_F, BRH_LED_BASE);  
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();
  nop();

  //  printk("create voltage scaling module successfully \n");
  return 0;
}


void cleanup_module(void) 
{
  /* put the voltage back to 1.5 v */
  printk("destroy voltage scaling module successfully \n");
}



