/* 
 * freqmeasurment.c: This program executes a fixed number of computation loops
 * and print the number of ticks it take. It is used to check if the frequency  * and voltage scaling has really been operated on Xscale 80200 BRH board.
 * 
 * Author: Saowanee Saewong (ssaewong@cmu.edu)
 *
 * Real-Time and Multimedia Systems Laboratory                                  * Copyright (c) 2002 Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <stdio.h>
#include <rk/rk.h>
#include <rk/timespec.h>
#include <rk/rk_error.h>
#include <rk/posix_timers.h>

int main(int argc, char **argv) {
  int i, j = 0;
  struct timespec fnow1, fnow2;                                                           
  printf(" Freq Measurement \n");

  /* read clock ticks here */
  clock_gettime(CLOCK_REALTIME, &fnow1);                                       
  printf("time now %d.%d \n", (unsigned int) fnow1.tv_sec, (unsigned int) fnow1.tv_nsec);

  for (i = 0; i < 0xffff; i++) {
    j = j + i * 5;
  }
  /* read clock ticks here */
  clock_gettime(CLOCK_REALTIME, &fnow2);                                       
  printf("time now %d.%d \n", (unsigned int) fnow2.tv_sec, (unsigned int ) fnow2.tv_nsec);
  timespec_sub(fnow2, fnow1);
  printf("time used %d.%d \n", (unsigned int) fnow2.tv_sec, (unsigned int) fnow2.tv_nsec);
  printf("j = %x \n", j);
  return 0;
}
