/* 
 * checkfreq.c: Check the current CLK setting on Xscale 80200 BRH board
 * 
 * Author: Saowanee Saewong (ssaewong@cmu.edu)
 *
 * Real-Time and Multimedia Systems Laboratory                                  * Copyright (c) 2002 Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>

#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/types.h>
#include <asm/hardware.h>

#include "VSCALE_BRH.h"

static int freq_now;

int init_module(void)
{
  /* Write to LED */
  printk("This is a kernel module to test voltage scaling on BRH \n");
  printk("Test LED \n");
  writeb(BRH_LED_HEX_4, BRH_LED_BASE);  

  /* Check the current CCLK Configuration */
  asm("MRC P14, 0, r1, C6, C0, 0\n"
      "ldr r4, =freq_now \n"
      "str r1, [r4]\n"
      );
  
  printk("freq_now = %d \n", freq_now);

  return 0;
}


void cleanup_module(void) 
{
  /* put the voltage back to 1.5 v */
  printk("destroy voltage scaling module successfully \n");
}



