/* 
 * BRH.h: Hardware addresses of xScale BRH board
 * 
 * Author: Saowanee Saewong (ssaewong@cmu.edu)
 *
 * Real-Time and Multimedia Systems Laboratory                                  * Copyright (c) 2002 Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */

#ifndef __VSCALE_BRH_h
#define __VSCALE_BRH_h

#ifdef __KERNEL__

/* For LED */
#define  BRH_LED_BASE          (volatile u32 *)(0xff200000)
#define  BRH_LED_HEX_0         0x40              /* 01000000b */   
#define  BRH_LED_HEX_1         0x79		 /* 01111001b */
#define  BRH_LED_HEX_2         0x24		 /* 00100100b */
#define  BRH_LED_HEX_3         0x30		 /* 00110000b */
#define  BRH_LED_HEX_4         0x19		 /* 00011001b */
#define  BRH_LED_HEX_5         0x12		 /* 00010010b */
#define  BRH_LED_HEX_6         0x02		 /* 00000010b */
#define  BRH_LED_HEX_7         0x78		 /* 01111000b */
#define  BRH_LED_HEX_8         0x00		 /* 00000000b */
#define  BRH_LED_HEX_9         0x18		 /* 00011000b */
#define  BRH_LED_HEX_A         0x08		 /* 00001000b */
#define  BRH_LED_HEX_B         0x03		 /* 00000011b */
#define  BRH_LED_HEX_C         0x46		 /* 01000110b */
#define  BRH_LED_HEX_D         0x21		 /* 00100001b */
#define  BRH_LED_HEX_E         0x06		 /* 00000110b */
#define  BRH_LED_HEX_F         0x0e		 /* 00001110b */

/* VOLTAGE CONTROL */
/* Physical : 0x033E0000, Virtual: 0xff3E0000 */
/* Actually, any address from 0x033E0000 to 0x033FFFFF is valid */

#define  BRH_VOLT_CONTROL      (volatile u32 *)(0xff3E0000)
/* Data to control voltage  from 1.00 V to 1.50 V */
#define  BRH_VOLT_150V         0x5               /* 0101b */
#define  BRH_VOLT_145V         0x6               /* 0110b */
#define  BRH_VOLT_140V         0x7               /* 0111b */
#define  BRH_VOLT_135V         0x8               /* 1000b */
#define  BRH_VOLT_130V         0x9               /* 1001b */
#define  BRH_VOLT_125V         0xa               /* 1010b */
#define  BRH_VOLT_120V         0xb               /* 1011b */
#define  BRH_VOLT_115V         0xc               /* 1100b */
#define  BRH_VOLT_110V         0xd               /* 1101b */
#define  BRH_VOLT_105V         0xe               /* 1110b */
#define  BRH_VOLT_100V         0xf               /* 1111b */
#endif
#endif 
