/*
 * rk_init.c: Initialization code for RK
 *
 * Copyright (C) 2000 TimeSys Corporation
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 * This file is derived from software distributed under the following terms:
 *
 * Real-Time and Multimedia Systems Laboratory
 * Copyright (c) 2000 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Real-Time and Multimedia Systems Laboratory
 *  Attn: Prof. Raj Rajkumar
 *  Electrical and Computer Engineering, and Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 *  or via email to raj@ece.cmu.edu
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
#include <rk/rk_linux.h>
#include <rk/rk.h>

extern void rk_reserve_init(void);
extern void rk_reserve_cleanup(void);
extern void rk_resource_set_init(void);
extern void rk_timer_init(void);
extern void rk_proc_init(void);
extern void disk_reserve_init(void);

extern rk_reserve_t cpu_reserve_dummy_create(rk_resource_set_t rs,
					     time_t duration);

cpu_tick_data_t rk_cpu_ticks_per_second;
cpu_tick_data_t rk_cpu_ticks_per_jiffy;

#ifdef	linux
void rk_cpu_calibration(void)
{
    printk("rk_cpu_calibration: Calibrating cpu ");
    {
	cpu_tick_data_t begin, end;

	unsigned long first_jiffies;
	int i = 5;

	/* wait for "start of" clock tick */
	first_jiffies = jiffies;
	while (first_jiffies == jiffies) {
	    /* nothing */
	}
	rk_rdtsc(&begin);
#ifdef DEBUG_BRH	
	printk("\n rk_cpu_calibration begin = %llu \n", begin);
#endif /* DEBUG_BRH */
	while (i-- > 0) {
	    first_jiffies = jiffies;
	    printk(".");
	    while (jiffies - first_jiffies < HZ) {
		/* nothing */
	    }
	}
	rk_rdtsc(&end);
	/* */
	rk_cpu_ticks_per_second = (end - begin) /5;

	{
	    cpu_tick_data_t ns = RK_NANOSECS_PER_JIFFY;
	    nanosec2tick(&ns, &rk_cpu_ticks_per_jiffy);
	}
	/* */
	rk_cpu_tick_at_boot = end - rk_cpu_ticks_per_jiffy * jiffies;
    }
    printk(" %llu cycles per second.\n", rk_cpu_ticks_per_second);
}

#endif

void rk_init(void)
{
    rk_reserve_init();
    rk_resource_set_init();
    rk_timer_init();
#ifdef	linux
    rk_cpu_calibration();
    rk_proc_init();
#endif
    //disk_reserve_init();
}

void rkcleanup(void)
{
    rk_reserve_cleanup();
}
