#ifndef __QOS_H__
#define __QOS_H__

#define MAXTASK 64		/* Maximum num of tasks that can be managed by QoSLib */

#define PSU 0.1			/* Bandwidth for PPS tasks */
#define PSQ 10000		/* Default scheduling quantum for PPS tasks */

		/* Task entry status */
#define UNVALID		0
#define VALID		1
#define PERIOD_CHANGED	2
#define Q_CHANGED	3

		/* Task classes */
#define FIXEDP 0
#define PPSTASK 1

		/* Structure used for creating a PPS task */
struct psparm {
    char *name;
     TASK(*body) (WORD);
    int arg;

    DWORD quantum;
    float w;
};

		/* Structure used for creating a MM or ED task */
struct qparm {
    char *name;
     TASK(*body) (WORD);
    int arg;

    DWORD wcet;
    float w;
    int reduce;
    DWORD per;
    BYTE model;
};

		/* General parameters for the QoS library */
struct qmparm {
    float psu;
    DWORD psq;
    float rmu;
};

		/* Structures describing a QoS managed task */
		/* Splitted in 2: local (task) and global (QoS Manager) */
struct qtask_local {
    void *adj;

    WORD desired;
    WORD incr;
    ID id;
};

struct qtask_global {
    DWORD q;			/* computation time */
    DWORD oldq;
    DWORD reqq;
    float reqb;
    DWORD per;			/* actual period */
    DWORD drel;
    DWORD oldp;			/* Old period */

    void *compress;
    ID id;			/* HARTIK PID 4 the process... Or RK RS!!! */
    BYTE valid;			/* Is the entry valid or changed?? */


    WORD type;
    struct qtask_global *next;
};


/* Prototypes */
int qman_init(struct qmparm *p);
ID qset_addtask(struct qparm *t);
ID ps_addtask(struct psparm *t);
void qtask_end(int retvalue);
DWORD qtask_endcycle(void);
void qtask_changeperiod(WORD p);
void setreq(struct reqactions *p);

#endif				/* __QOS_H__ */
