#ifndef __ASM_MSR_H
#define __ASM_MSR_H

/*
 * Access to machine-specific registers (available on 586 and better only)
 * Note: the rd* operations modify the parameters directly (without using
 * pointer indirection), this allows gcc to optimize better
 */

#define rdmsr(msr,val1,val2) \
     __asm__ __volatile__("rdmsr" \
			  : "=a" (val1), "=d" (val2) \
			  : "c" (msr))

#define wrmsr(msr,val1,val2) \
     __asm__ __volatile__("wrmsr" \
			  : /* no outputs */ \
			  : "c" (msr), "a" (val1), "d" (val2))

#define rdtsc(low,high) \
     __asm__ __volatile__("rdtsc" : "=a" (low), "=d" (high))

#define rdtscl(low) \
     __asm__ __volatile__("rdtsc" : "=a" (low) : : "edx")

#define rdtscll(val) \
     __asm__ __volatile__("rdtsc" : "=A" (val))

#define write_tsc(val1,val2) wrmsr(0x10, val1, val2)

#define rdpmc(counter,low,high) \
     __asm__ __volatile__("rdpmc" \
			  : "=a" (low), "=d" (high) \
			  : "c" (counter))

/* symbolic names for some interesting MSRs */
#define MSR_IA32_PLATFORM_ID		0x017

#define MSR_IA32_APICBASE		0x01b
#define		MSR_IA32_APICBASE_BSP		(1<<8)
#define		MSR_IA32_APICBASE_ENABLE	(1<<11)
#define		MSR_IA32_APICBASE_BASE		(0xfffff<<12)

#define MSR_IA32_UCODE_WRITE		0x079
#define MSR_IA32_UCODE_REV		0x08b

#define MSR_IA32_PERFCTR0		0x0c1
#define MSR_IA32_PERFCTR1		0x0c2

#define MSR_IA32_MCG_CAP		0x179
#define MSR_IA32_MCG_STATUS		0x17a
#define MSR_IA32_MCG_CTL		0x17b

#define MSR_IA32_EVNTSEL0		0x186
#define MSR_IA32_EVNTSEL1		0x187

#define MSR_IA32_DEBUGCTLMSR		0x1d9
#define MSR_IA32_LASTBRANCHFROMIP	0x1db
#define MSR_IA32_LASTBRANCHTOIP		0x1dc
#define MSR_IA32_LASTINTFROMIP		0x1dd
#define MSR_IA32_LASTINTTOIP		0x1de

#define MSR_IA32_MC0_BASE		0x400
#define		MSR_IA32_MC0_CTL_OFFSET		0x0
#define		MSR_IA32_MC0_STATUS_OFFSET	0x1
#define		MSR_IA32_MC0_ADDR_OFFSET	0x2
#define		MSR_IA32_MC0_MISC_OFFSET	0x3
#define		MSR_IA32_MC0_BANK_COUNT		0x4

#define MSR_K7_EVNTSEL0			0xC0010000
#define MSR_K7_PERFCTR0			0xC0010004

#endif /* __ASM_MSR_H */
