#ifndef _ABI_SYSENT_H
#define _ABI_SYSENT_H

/*
 *  The Linux-ABI syscall handling.
 *
 * $Id: sysent.h,v 1.4 2001/07/13 13:37:48 hch Exp $
 * $Source: /work/people/hch/cvs/abi/include/abi/sysent.h,v $
 */

struct pt_regs;
struct abi_function;

/* XXX kill these */
#define SC(name)		(void *)__NR_##name
#define ITR(trace, name, args)	,name,args

/*
 * This is needed for subdispatchers like cxenix().
 */
extern void	abi_dispatch(struct pt_regs *, struct abi_function *, int);


/* 
 *  - If an entry is 'Ukn' we don't know how to handle it yet.
 *  - Spl means that we need to do special processing for this syscall.
 *  - Fast means that even the error return handling is done by the function.
 */
#define ZERO	0x64	/* Um, magic zero for callmap. Don't ask :-). */
#define Spl	0x65	/* pass the regs structure down */
#define Ukn	0x66	/* no code to handle this case yet */
#define Fast	0x67	/* magic on return, return regs already set up */

/*
 * the function prefix sys_... are used by linux in native mode.
 * abi_, svr4_, sol_, uw7_ and ibcs_... are emulation interfaces for routines that 
 * differ from iBCS2 and linux.  The xnx_... are xenix routines.
 */
struct abi_function {
	void	*kfunc;	/* function to call (svr4_, xnx_ or sco_)
			   or pointer to a sub class.			*/
	short	nargs;	/* number of args to kfunc or Ukn, Spl or Fast	*/
	char	*name;	/* name of function (for tracing)		*/
	char	*args;	/* how to print the arg list (see plist)	*/
};
typedef struct abi_function abi_func_t;

#endif /* _ABI_SYSENT_H */
