/*
 * Copyright (c) 2001 Caldera Deutschland GmbH.
 * Copyright (c) 2001 Christoph Hellwig.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: types.h,v 1.1 2001/07/30 11:51:12 hch Exp $
 */
#ifndef _ABI_SVR4_TYPES_H
#define _ABI_SVR4_TYPES_H

typedef long		svr4_off_t;
typedef u_long		svr4_dev_t;
typedef u_long		svr4_ino_t;
typedef u_int		svr4_mode_t;
typedef u_int		svr4_nlink_t;
typedef int		svr4_uid_t;
typedef int		svr4_gid_t;
typedef long		svr4_daddr_t;
typedef int		svr4_pid_t;
typedef long		svr4_time_t;
typedef long		svr4_blkcnt_t;
typedef u_long		svr4_fsblkcnt_t;
typedef char *		svr4_caddr_t;
typedef u_long		svr4_size_t;

typedef short		svr4_o_dev_t;
typedef short		svr4_o_pid_t;
typedef u_short		svr4_o_ino_t;
typedef u_short		svr4_o_mode_t;
typedef short		svr4_o_nlink_t;
typedef u_short		svr4_o_uid_t;
typedef u_short		svr4_o_gid_t;
typedef long		svr4_clock_t;
typedef int		svr4_key_t;

#define linux_to_svr4_dev_t(d)		((d & 0xff) | ((d & 0xff00) << 10))
#define linux_to_svr4_o_dev_t(d)	(d) /* XXX fixme */


#endif /* _ABI_SVR4_TYPES_H */
