#ifndef _ABI_SVR4_SYSENT_H
#define _ABI_SVR4_SYSENT_H

/*
 *  Function prototypes used for the SVR4 emulator.
 *
 * $Id: sysent.h,v 1.7 2001/07/16 12:09:48 hch Exp $
 * $Source: /work/people/hch/cvs/abi/include/abi/svr4/sysent.h,v $
 */

struct abi_sigaction;
struct ibcs_stat;
struct ibcs_statfs;
struct svr4_siginfo;
struct svr4_sigset;
struct pt_regs;
struct timeval;


/* MD (lcall7.c for i386) */
extern int	abi_syscall(struct pt_regs *);

/* fcntl.c */
extern int	svr4_fcntl(struct pt_regs *);

/* hrtsys.c */
extern int	svr4_hrtsys(struct pt_regs *);

/* ioctl.c */
extern int	svr4_ioctl(struct pt_regs *);

/* ipc.c */
extern int	svr4_semsys(struct pt_regs *);
extern int	svr4_shmsys(struct pt_regs *);
extern int	svr4_msgsys(struct pt_regs *);

/* isc.c */
extern int	isc_setostype(int);

/* misc.c */
extern int	abi_brk(u_long);
extern int	abi_exec(struct pt_regs *);
extern int	abi_fork(struct pt_regs *);
extern int	abi_getpid(struct pt_regs *);
extern int	abi_getuid(struct pt_regs *);
extern int	abi_getgid(struct pt_regs *);
extern int	abi_mkdir(const char *, int);
extern int	abi_mknod(const char *, int, int);
extern int	abi_kill(int, int);
extern int	abi_pipe(struct pt_regs *);
extern int	abi_procids(struct pt_regs *);
extern int	abi_read(int, char *, int);
extern int	abi_select(int, void *, void *, void *, struct timeval *);
extern int	abi_time(void);
extern int	abi_wait(struct pt_regs *);

/* mmap.c */
extern int	svr4_mmap(u_int, u_int, int, int, int, u_int);

/* open.c */
extern int	svr4_open(const char *, int, int);
extern int	svr4_statfs(const char *, struct ibcs_statfs *, int, int);
extern int	svr4_fstatfs(u_int, struct ibcs_statfs *, int, int);
extern int	svr4_getdents(int, char *, int);

/* signal.c */
extern int	abi_sigsuspend(struct pt_regs *);
extern int	abi_sigfunc(struct pt_regs *);
extern int	abi_sigaction(int, const struct abi_sigaction *,
			struct abi_sigaction *);
extern int	abi_sigprocmask(int, u_long *, u_long *);
extern int	abi_sigsuspend(struct pt_regs *);

/* socksys.c */
extern int	socksys_syscall(u_long *);

/* stream.c */
extern int	svr4_getmsg(struct pt_regs *);
extern int	svr4_putmsg(struct pt_regs *);
extern int	svr4_getpmsg(struct pt_regs *);
extern int	svr4_putpmsg(struct pt_regs *);

/* svr4.c */
extern int	svr4_access(char *, int);
extern int	svr4_waitid(int, int, struct svr4_siginfo *, int);
extern int	svr4_waitsys(struct pt_regs *);
extern int	svr4_seteuid(int);
extern int	svr4_setegid(int);
extern int	svr4_fpathconf(int, int);
extern int	svr4_pathconf(char *, int);
extern int	svr4_sigpending(int, struct svr4_sigset *);
extern int	svr4_context(struct pt_regs *);

/* sysconf.c */
extern int	ibcs_sysconf(int);

/* sysfs.c */
extern int	svr4_sysfs(int, int, int);

/* sysinfo.c */
extern int	svr4_sysinfo(int, char *, long);

/* ulimit.c */
extern int	svr4_ulimit(int, int);
extern int	svr4_getrlimit(int, void *);
extern int	svr4_setrlimit(int, void *);

/* xstat.c */
extern int	abi_statvfs(char *, void *);
extern int	abi_fstatvfs(int, void *);
extern int	svr4_xstat(int, char *, void *);
extern int	svr4_fxstat(int, int, void *);
extern int	svr4_lxstat(int, char *, void *);
extern int	svr4_xmknod(int, const char *, mode_t, dev_t);

/* stat.c */
extern int	abi_stat(char *, struct ibcs_stat *);
extern int	abi_lstat(char *, struct ibcs_stat *);
extern int	abi_fstat(u_int, struct ibcs_stat *);

/* sysconf.c */
extern int	svr4_sysconfig(int);

/* sysi86.c */
extern int	svr4_sysi86(struct pt_regs *);

/* utsname.c */
extern int	abi_utsname(u_long);
extern int	v7_utsname(u_long);

#endif /* _ABI_SVR4_SYSENT_H */
