/*
 * Copyright (c) 2001 Christoph Hellwig.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _ABI_STAT_H
#define _ABI_STAT_H

#ident "$Id: stat.h,v 1.2 2001/04/10 21:55:38 hch Exp $"

/*
 * Templates for constructing stat,lstat and fstat syscalls.
 * We had far too much code duplication in the abi code, this
 * is a try to unify the codebase (and thus the ugly, huge macros...
 *
 * Usage:
 * 	DEF_{STAT,LSTAT,FSTAT}(functionname, statstruct, copyfunction)
 */

#define DEF_STAT(name, stat_t, docopy)					\
int name(char *path, stat_t * stp)					\
{									\
	struct nameidata	nd;					\
	int			error;					\
									\
	if (!(error = user_path_walk((path), &nd))) {			\
		if (!(error = do_revalidate(nd.dentry)))		\
			error = docopy(nd.dentry->d_inode, stp);	\
		path_release(&nd);					\
	}								\
									\
	return (error);							\
}

#define DEF_LSTAT(name, stat_t, docopy)					\
int name(char *path, stat_t * stp)					\
{									\
	struct nameidata	nd;					\
	int			error;					\
									\
	if (!(error = user_path_walk_link((path), &nd))) {		\
		if (!(error = do_revalidate(nd.dentry)))		\
			error = docopy(nd.dentry->d_inode, stp);	\
		path_release(&nd);					\
	}								\
									\
	return (error);							\
}

#define DEF_FSTAT(name, stat_t, docopy)					\
int name(u_int fd, stat_t * stp)						\
{									\
	struct file *		fp;					\
	int			error = -EBADF;				\
									\
	if ((fp = fget(fd))) {						\
		struct dentry *	dp = fp->f_dentry;			\
		if (!(error = do_revalidate(dp)))			\
			error = docopy(dp->d_inode, stp);		\
		fput(fp);						\
	}								\
									\
	return (error);							\
}

#endif /* _ABI_STAT_H */
