#ifndef _ABI_MAP_H
#define _ABI_MAP_H
/*
 *  include/abi/map.h
 *
 *  Copyright (C) 1994  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: map.h,v 1.3 2001/07/16 12:25:51 hch Exp $
 * $Source: /work/people/hch/cvs/abi/include/abi/map.h,v $
 */

struct map_segment {
	int	start, end;
	u_char	*map;
};

extern long	map_bitvec(u_long vec, long map[]);
extern u_long	map_sigvec_from_kernel(sigset_t vec, u_long map[]);
extern sigset_t	map_sigvec_to_kernel(u_long vec, u_long map[]);
extern int	map_value(struct map_segment *m, int val, int def);

static __inline u_short
map_flags(u_short f, u_short map[])
{
        u_short		m, r = 0;
        int		i;

        for (i = 0, m = 1; i < 16; i++) {
                if (f & m)
                        r |= map[i];
		m <<= 1;
	}

        return r;
}

#endif /* ABI_MAP_H */
