/*
 *  These are defined to enable their inclsion in the branch table
 *  defined below.
 *
 *  Hacked by Eric Youngdale for iBCS (1993, 1994).
 *
 * $Id: abi4.h,v 1.4 2001/07/13 13:37:48 hch Exp $
 * $Source: /work/people/hch/cvs/abi/include/abi/abi4.h,v $
 */

#ifndef __ABI_ABI_H__
#define __ABI_ABI_H__

typedef unsigned long ABI_dev_t;
typedef unsigned long ABI_ino_t;
typedef unsigned long ABI_mode_t;
typedef unsigned long ABI_nlink_t;
typedef long ABI_uid_t;
typedef long ABI_off_t;
typedef struct timeval ABI_timestruc_t;


struct abi_sigaction {
       int          sa_flags;
       __sighandler_t sa_handler;
       unsigned long sa_mask;
       int	    sa_resv[2];  /* Reserved for something or another */
};
#define ABI_SA_ONSTACK   1
#define ABI_SA_RESETHAND 2
#define ABI_SA_RESTART   4
#define ABI_SA_SIGINFO   8
#define ABI_SA_NODEFER  16
#define ABI_SA_NOCLDWAIT 0x10000
#define ABI_SA_NOCLDSTOP 0x20000



/*
 * This is the general form of the stat structure in an ABI compliant system.
 */

struct	svr4_xstat {
	ABI_dev_t	st_dev;
	long	st_pad1[3];	 
	ABI_ino_t	st_ino;
	ABI_mode_t	st_mode;
	ABI_nlink_t st_nlink;
	ABI_uid_t 	st_uid;
	ABI_uid_t 	st_gid;
	ABI_dev_t	st_rdev;
	long	st_pad2[2];
	ABI_off_t	st_size;
	long	st_pad3;	 
	ABI_timestruc_t st_atim;	
	ABI_timestruc_t st_mtim;	
	ABI_timestruc_t st_ctim;	
	long	st_blksize;
	long	st_blocks;
	char	st_fstype[ 16 ] ;
	long	st_pad4[8];
};

/*
 * Structure used by statvfs syscall.
 */
struct abi_statvfs {
  unsigned long f_bsize; /* blocksize */
  unsigned long f_frsize; /* fragment size. */
  unsigned long f_blocks;
  unsigned long f_bfree;
  unsigned long f_bavail;
  unsigned long f_files;
  unsigned long f_free;
  unsigned long f_sid;
  char	        f_basetype[16];
  unsigned long f_flag;
  unsigned long f_namemax;
  char		f_fstr[32];
  unsigned long f_filler[16];
};

struct sco_statvfs {
  unsigned long f_bsize; /* blocksize */
  unsigned long f_frsize; /* fragment size. */
  unsigned long f_blocks;
  unsigned long f_bfree;
  unsigned long f_bavail;
  unsigned long f_files;
  unsigned long f_free;
  unsigned long f_favail;
  unsigned long f_sid;
  char	        f_basetype[16];
  unsigned long f_flag;
  unsigned long f_namemax;
  char		f_fstr[32];
  unsigned long f_filler[16];
};

/* POSIX.1 names */
#define _PC_LINK_MAX    1
#define _PC_MAX_CANON   2
#define _PC_MAX_INPUT   3
#define _PC_NAME_MAX    4
#define _PC_PATH_MAX    5
#define _PC_PIPE_BUF    6
#define _PC_NO_TRUNC    7
#define _PC_VDISABLE    8
#define _PC_CHOWN_RESTRICTED    9
/* POSIX.4 names */
#define _PC_ASYNC_IO    10
#define _PC_PRIO_IO     11
#define _PC_SYNC_IO     12
#endif
