
#ifndef _ABI_ABI_H
#define _ABI_ABI_H
/*
 *  Catchall for misc. Linux-ABI prototypes and definitions.
 *
 * $Id: abi.h,v 1.18 2001/07/16 15:07:22 hch Exp $
 * $Source: /work/people/hch/cvs/abi/include/abi/abi.h,v $
 */

#include <linux/ptrace.h>	/* for pt_regs */
#include <linux/sched.h>
#include <linux/signal.h>
#include <linux/unistd.h>

#include <abi/stream.h>
#include <abi/map.h>
#include <asm/abi.h>

/*
 * This is straight from linux/fs/stat.c. It is required for
 * proper NFS attribute caching (so it says there). Maybe the
 * kernel should export it - but it is basically simple...
 */
static __inline__ int
do_revalidate(struct dentry *dentry)
{
	struct inode *inode = dentry->d_inode;
	if (inode->i_op && inode->i_op->revalidate)
		return inode->i_op->revalidate(dentry);
	return 0;
}


struct ibcs_statfs {
	short f_type;
	long f_bsize;
	long f_frsize;
	long f_blocks;
	long f_bfree;
	long f_files;
	long f_ffree;
	char f_fname[6];
	char f_fpack[6];
};

struct ibcs_stat {
        unsigned short st_dev;
        unsigned short st_ino;
        unsigned short st_mode;
        unsigned short st_nlink;
        unsigned short st_uid;
        unsigned short st_gid;
        unsigned short st_rdev;
        unsigned long  st_size;
        unsigned long  st_atime;
        unsigned long  st_mtime;
        unsigned long  st_ctime;
};

#define SVR4_CLD_EXITED		1
#define SVR4_CLD_KILLED		2
#define SVR4_CLD_DUMPED		3
#define SVR4_CLD_TRAPPED	4
#define SVR4_CLD_STOPPED	5
#define SVR4_CLD_CONTINUED	6

/*
 * Translate the errno numbers from linux to current personality.
 * This should be removed and all other sources changed to call the
 * map function above directly.
 */
#define iABI_errors(errno) \
	(map_value(current->exec_domain->err_map, errno, 1))

#endif /* _ABI_ABI_H */
