 /*
 * Driver for Microtek Scanmaker X6 USB scanner and possibly others.
 * 
 * (C) Copyright 2000 John Fremlin <vii@penguinpowered.com>
 * (C) Copyright 2000 Oliver Neukum <Oliver.Neukum@lrz.uni-muenchen.de>
 *
 * See microtek.c for history
 *
 */

typedef void (*usc_scsi_cmnd_callback)(Scsi_Cmnd *);
typedef void (*usc_usb_urb_callback) (struct urb *);


struct usc_transfer_context
{
	struct usc_desc* instance;
	usc_scsi_cmnd_callback final_callback;
	Scsi_Cmnd *srb;
	
	void* data;
	unsigned data_length;
	int data_pipe;

 	int lock;

	atomic_t do_abort; /* when != 0 URB completion routines will
			      return straightaway */
	
	u8 status; /* status returned from ep_response after command completion */
};


struct usc_desc {
	struct usc_desc *next;
	struct usc_desc *prev;

	struct usb_device *usb_dev;
	
	int interface;

	/* Endpoint addresses */
	u8 ep_out;
	u8 ep_response;
	u8 ep_image;
	u8 interrupt_interval;
	int image_pipe;
	int status_pipe;
	int out_pipe;
	
	struct Scsi_Host * host;
	Scsi_Host_Template ctempl;
	int host_number;
	
	struct semaphore cmd_lock;
	struct semaphore status_lock;

	struct urb cmd_urb;
	struct urb status_urb;
	struct usc_transfer_context context;
};


#define USC_EP_OUT	0x1
#define USC_EP_RESPONSE	0x2
#define USC_EP_IMAGE	0x3
#define USC_EP_TOTAL	0x3

#define USC_SCSI_ERR_MASK ~0x3fu 
