/*
 * iSCSI driver for Linux
 * Copyright (C) 2001 Cisco Systems, Inc.
 * maintained by linux-iscsi@cisco.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * See the file COPYING included with this distribution for more details.
 *
 * $Id: scsiTcp.h,v 1.1.2.1 2001/06/12 20:56:13 mpm Exp $ 
 *
 */


#ifndef __SCSITCP_h__
#define __SCSITCP_h__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef VXWORKS
#include <vxWorks.h>
#else
typedef unsigned char	UINT8;
typedef unsigned short	UINT16;
typedef unsigned int	UINT32;
#ifndef WIN32
#if (__BYTE_ORDER == __BIG_ENDIAN)
#ifndef __IEEE_BIG_ENDIAN
#define __IEEE_BIG_ENDIAN	1
#endif
#endif
#endif /* WIN32 */
#endif

/* SCSI/TCP listen port for incoming connections */
#define SCSI_TCP_LISTEN_PORT 5003

/* Version Numbers - version format is: iv.vv.sv                */
/*                   where:  iv is the iSCSI version number,    */
/*                           vv is the vendor version number,   */
/*                           sv is the subsystem version number */
#define SCSI_TCP_ISCSI_VERSION	0
#define SCSI_TCP_CISCO_VERSION	8

/* SCSI/TCP Template Message Header */
struct ScsiTcpHdr {
    UINT8  opcode;	/* see Message Opcode values below */
    UINT8  rsvd1[3];
    UINT32 length;
    UINT8  lun[8];
    UINT32 itt;		/* Initiator Task Tag */
    UINT8  other[28];
};

/* Opcode encoding bits */
#define SCSI_TCP_OP_RETRY              0x80
#define SCSI_TCP_OP_RSP                0x40

/* Client to Server Message Opcode values */
#define SCSI_TCP_OP_NOOP_OUT           0x00
#define SCSI_TCP_OP_SCSI_CMD           0x01
#define SCSI_TCP_OP_SCSI_TASK_MGT_MSG  0x02
#define SCSI_TCP_OP_LOGIN_CMD          0x03
#define SCSI_TCP_OP_TEXT_CMD           0x04
#define SCSI_TCP_OP_SCSI_DATA          0x05
#define SCSI_TCP_OP_RTT_CMD            0x06
#define SCSI_TCP_OP_PING_CMD           0x09
#define SCSI_TCP_OP_MAP_CMD            0x0a

/* Server to Client Message Opcode values */
#define SCSI_TCP_OP_NOOP_IN            (0x00 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_SCSI_RSP           (0x01 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_SCSI_TASK_MGT_RSP  (0x02 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_LOGIN_RSP          (0x03 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_TEXT_RSP           (0x04 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_SCSI_DATA_RSP      (0x05 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_RTT_RSP            (0x06 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_ASYNC_EVENT        (0x07 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_INVALID_OPCODE     (0x08 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_PING_RSP           (0x09 | SCSI_TCP_OP_RSP)
#define SCSI_TCP_OP_MAP_RSP            (0x0a | SCSI_TCP_OP_RSP)


struct ScsiTcpCmdFlags {
#ifdef __IEEE_BIG_ENDIAN
    UINT8 imm_data:2,		/* see Immediate data flags values below */
	  read_data:1,
	  rsvd1:5,
	  autosense_disable:1,
	  rsvd2:4,
	  attr:3;		/* see SCSI Command Attribute values below */
#else
    UINT8 rsvd1:5,
	  read_data:1,
	  imm_data:2,		/* see Immediate data flags values below */
          attr:3,		/* see SCSI Command Attribute values below */
	  rsvd2:4,
	  autosense_disable:1;
#endif
};

/* Immediate data flags */
#define SCSI_TCP_IMM_DATA_ALL_DATA	0
#define SCSI_TCP_IMM_DATA_ALL_CDB	1
#define SCSI_TCP_IMM_DATA_34_DATA	2
#define SCSI_TCP_IMM_DATA_HALF_DATA	3

/* SCSI Command Attribute values */
#define SCSI_TCP_ATTR_UNTAGGED		0
#define SCSI_TCP_ATTR_SIMPLE		1
#define SCSI_TCP_ATTR_ORDERED		2
#define SCSI_TCP_ATTR_HEAD_OF_QUEUE	3
#define SCSI_TCP_ATTR_ACA		4

/* SCSI Command Header */
struct ScsiTcpScsiCmdHdr {
    UINT8                  opcode;
    struct ScsiTcpCmdFlags flags;
    UINT8                  rsvd3;
    UINT32                 length;
    UINT8                  lun[8];
    UINT32                 itt;		/* Initiator Task Tag */
    UINT32                 data_length;
    UINT32                 cmdrn;
    UINT32                 expstatrn;
    UINT8                  scb[16];	/* SCSI Command Block */
    /* Additional Data (Command Dependent) */
};


struct ScsiTcpCmdRespFlags {
#ifdef __IEEE_BIG_ENDIAN
    UINT8 rsvd1:6,
          overflow:1,
          underflow:1;
#else
    UINT8 underflow:1,
          overflow:1,
          rsvd1:6;
#endif
};

/* SCSI Response Header */
struct ScsiTcpScsiRspHdr {
    UINT8                       opcode;
    struct ScsiTcpCmdRespFlags  flags;
    UINT16                      rsvd2;
    UINT32                      length;
    UINT8                       rsvd3[8];
    UINT32                      itt;		/* Initiator Task Tag */
    UINT32                      residual_count;
    UINT32                      statrn;
    UINT32                      expcmdrn;
    UINT32                      maxcmdrn;
    UINT8                       cmd_status;
    UINT8                       iscsi_status;	/* see SCSI/TCP Status values below */
    UINT16                      rsvd4;
    UINT16                      res_len;
    UINT16                      sense_len;
    UINT32                      rsvd5;
    /* Response or Sense Data (optional) */
};

/* Asynchronous Event Header */
struct ScsiTcpAsyncEvtHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT8  lun[8];
    UINT32 rsvd2[2];
    UINT32 statrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT8  scsi_event_ind;	/* see SCSI Event Indicator values below */
    UINT8  iscsi_event_ind;	/* see iSCSI Event Indicator values below */
    UINT8  rsvd3[10];
    /* Sense Data */
};

/* SCSI/TCP Status values */
#define SCSI_TCP_STATUS_GOOD                 0
#define SCSI_TCP_STATUS_CHECK                1

/* iSCSI Event Indicator values */
#define SCSI_TCP_EVT_IND_TARGET_RESETTING    2

/* SCSI Event Indicator values */
#define SCSI_TCP_SCSI_EVT_IND_ERROR          1
#define SCSI_TCP_SCSI_EVT_IND_DEV_AVAILABLE  2
#define SCSI_TCP_SCSI_EVT_IND_UNIT_ATTENTION 3
#define SCSI_TCP_SCSI_EVT_IND_ASYNC_EVENT    4

/* NOP-Out Message */
struct ScsiTcpNopOutHdr {
    UINT8  opcode;
#ifdef __IEEE_BIG_ENDIAN
    UINT8  poll:1,
           rsvd1:7;
#else
    UINT8  rsvd1:7,
           poll:1;
#endif
    UINT16 rsvd2;
    UINT32 length;
    UINT32 rsvd3[5];
    UINT32 expstatrn;
    UINT32 rsvd4[4];
};

/* NOP-In Message */
struct ScsiTcpNopInHdr {
    UINT8  opcode;
#ifdef __IEEE_BIG_ENDIAN
    UINT8  poll:1,
           rsvd1:7;
#else
    UINT8  rsvd1:7,
           poll:1;
#endif
    UINT16 rsvd2;
    UINT32 length;
    UINT32 rsvd3[5];
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT32 rsvd4[3];
};

/* SCSI Task Management Message Header */
struct ScsiTcpScsiTaskMgtHdr {
    UINT8  opcode;
    UINT8  function;	/* see Function values below */
    UINT16 rsvd1;
    UINT32 length;
    UINT8  lun[8];
    UINT32 itt;		/* Initiator Task Tag */
    UINT32 rtt;		/* Reference Task Tag */
    UINT32 cmdrn;
    UINT32 expstatrn;
    UINT32 rsvd2[4];
};

/* Function values */
#define SCSI_TCP_TM_FUNC_ABORT_TASK         1
#define SCSI_TCP_TM_FUNC_ABORT_TASK_SET     2
#define SCSI_TCP_TM_FUNC_CLEAR_ACA          3
#define SCSI_TCP_TM_FUNC_CLEAR_TASK_SET     4
#define SCSI_TCP_TM_FUNC_LOGICAL_UNIT_RESET 5
#define SCSI_TCP_TM_FUNC_TARGET_RESET       6
#define SCSI_TCP_TM_FUNC_LOGOUT             0xffff	// internal use only

/* SCSI Task Management Response Header */
struct ScsiTcpScsiTaskMgtRspHdr {
    UINT8  opcode;
    UINT8  response;	/* see Response values below */
    UINT16 rsvd1;
    UINT32 length;
    UINT8  lun[8];
    UINT32 itt;		/* Initiator Task Tag */
    UINT32 rsvd2;
    UINT32 statrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT8  rsvd3[12];
};

/* Response values */
#define SCSI_TCP_TM_RESP_COMPLETE           0
#define SCSI_TCP_TM_RESP_REJECTED           1

/* Ready To Transfer Header */
struct ScsiTcpRttHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;		/* Initiator Task Tag */
    UINT32 data_length;
    UINT32 data_offset;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT32 ttt;		/* Target Transfer Tag */
    UINT32 rsvd3[2];
};

/* SCSI Data Hdr */
struct ScsiTcpDataHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 offset;
    UINT32 ttt;
    UINT32 itt;
    UINT32 rsvd2;
    UINT32 cmdrn;
    UINT32 expstatrn;
    UINT32 rsvd3[4];
    /* Payload */
};

/* SCSI Data Response Hdr */
struct ScsiTcpDataRspHdr {
    UINT8  opcode;
#ifdef __IEEE_BIG_ENDIAN
    UINT8  rsvd1:5,
           status_present:1,
           overflow:1,
           underflow:1;
#else
    UINT8  underflow:1,
           overflow:1,
           status_present:1,
           rsvd1:5;
#endif
    UINT16 rsvd2;
    UINT32 length;
    UINT32 offset;
    UINT32 ttt;
    UINT32 itt;
    UINT32 residual_count;
    UINT32 statrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT8  cmd_status;
    UINT8  iscsi_status;	/* see SCSI/TCP Status values above */
    UINT8  rsvd3[10];
};

/* Text Header */
struct ScsiTcpTextHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;
    UINT32 rsvd3;
    UINT32 cmdrn;
    UINT32 expstatrn;
    UINT32 rsvd4[4];
    /* Text - key:value pairs */
};

/* Text Response Header */
struct ScsiTcpTextRspHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;
    UINT32 rsvd3;
    UINT32 statrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT32 rsvd4[3];
    /* Text Response - key:value pairs */
};

/* Login Header */
struct ScsiTcpLoginHdr {
    UINT8  opcode;
    UINT8  type;	/* see Login Type values below */
    UINT8  rsvd1;
    UINT8  version;     /* This should be set to SCSI_TCP_ISCSI_VERSION */
    UINT32 length;
    UINT16 cid;
    UINT16 recover_cid;
    UINT32 rsvd2;
    UINT16 isid;        /* Initiator Session ID */
    UINT16 tsid;        /* Target Session ID */
    UINT32 rsvd3;
    UINT32 initcmdrn;
    UINT32 rsvd4[5];
};

/* Login Types */
#define SCSI_TCP_LOGIN_NO_AUTH   0x00
#define SCSI_TCP_LOGIN_IMPLICIT  0x01
#define SCSI_TCP_LOGIN_CLRTXTPWD 0x02
#define SCSI_TCP_LOGIN_RSA1WAY   0x03
#define SCSI_TCP_LOGIN_RSA2WAY   0x04

/* Login Response Header */
struct ScsiTcpLoginRspHdr {
    UINT8  opcode;
    UINT8  rsvd1[2];
    UINT8  version;     /* This should be set to SCSI_TCP_ISCSI_VERSION */
    UINT32 length;
    UINT32 rsvd2[2];
    UINT16 isid;        /* Initiator Session ID */
    UINT16 tsid;        /* Target Session ID */
    UINT32 rsvd3;
    UINT32 initstatrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT8  status;	   /* see Login Status values below */
    UINT8  rsvd4[11];
};

/* Login Status values */
#define SCSI_TCP_LOGIN_STATUS_ACCEPT       0
#define SCSI_TCP_LOGIN_STATUS_REJECT       1
#define SCSI_TCP_LOGIN_STATUS_AUTHENTICATE 2
#define SCSI_TCP_LOGIN_REJECT_RECOVERY     3

/* Ping Request Header */
struct ScsiTcpPingHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;
    UINT32 rsvd3;
    UINT32 cmdrn;
    UINT32 expstatrn;
    UINT32 rsvd4[4];
};

/* Ping Response Header */
struct ScsiTcpPingRspHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;
    UINT32 rsvd3;
    UINT32 statrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT32 rsvd4[3];
};

/* Map Command Header */
struct ScsiTcpMapHdr {
    UINT8  opcode;
    UINT8  function;
    UINT16 rsvd1;
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;
    UINT32 rsvd3;
    UINT32 cmdrn;
    UINT32 expstatrn;
    UINT32 rsvd4[4];
};

/* Map Functions */
#define SCSI_TCP_MAP   0x00
#define SCSI_TCP_UNMAP 0x01

/* Map Command Descriptor */
struct ScsiTcpMapDescr {
    UINT16 type;
    UINT16 length;
    UINT8  descr[1];
};

/* Map Descriptor Types */
#define SCSI_TCP_MAP_DESCR_IP4	0x0000
#define SCSI_TCP_MAP_DESCR_IP6	0x0001
#define SCSI_TCP_MAP_DESCR_URL	0x0002
#define SCSI_TCP_MAP_DESCR_FCA	0x0003
#define SCSI_TCP_MAP_DESCR_PRX	0x0004

/* Map Command Response Header */
struct ScsiTcpMapRspHdr {
    UINT8  opcode;
    UINT8  rsvd1[3];
    UINT32 length;
    UINT32 rsvd2[2];
    UINT32 itt;
    UINT32 rsvd3;
    UINT32 statrn;
    UINT32 expcmdrn;
    UINT32 maxcmdrn;
    UINT8  response;
    UINT8  rsvd4[11];
};

/* Map Command Responses */
#define SCSI_TCP_MAP_RSP_COMPLETE   0x00
#define SCSI_TCP_MAP_RSP_BAD_DESC   0x01
#define SCSI_TCP_MAP_RSP_2MANY_DESC 0x02
#define SCSI_TCP_MAP_RSP_UNMAP_REJ  0x03

/*
 * LUN manipulation
 *
 * The first level address is all we are using.  We do use both the logical
 * unit (multiple targets per connection) and peripheral device addressing
 * methods (single target per connection).
 */
#define GET_LUN_TARGET(LUN)    ((LUN[0] & 0x80) ? (LUN[0]&0x3f) : 0)
#define GET_LUN(LUN)           ((LUN[0] & 0x80) ? (LUN[1]&0x1f) : LUN[1])
#define IS_TARGET_PRESENT(LUN) (LUN[0] & 0x80)

#ifdef __cplusplus
}
#endif

#endif
