/********************************************************************************
* QLogic ISP2x00 device driver for Linux 2.2.x and 2.4.x 
* Copyright (C) 2000,2001         Qlogic Corporation 
* (www.qlogic.com)
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2, or (at your option) any
* later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
**
******************************************************************************/

/*
 * vendor specific op codes.
*/

#define	UCSCSI_DCMD			0x20 /* DAC960 direct command */
#define UCSCSI_DCMD_PASSTHRU		0x21 /* DAC960 pass-through command */
#define	UC_SCSI_DCMD			0x22 /* DAC960 FSI direct command */
#define DAC_CDB_LEN			12
#define DAC_SENSE_LEN			64

#define SCSI_WRITE10			0x2A	/* Required for direct disk writes */
#define SCSI_WRITE6			0x0A	/* Required for direct disk writes */
#define SCSI_WRITEBUFFER		0x3B	/* Required for flashing disk FW */
#define DACMD_WRITE_CONF_ONDISK		0x4B
#define	DACMD_WRITE_CONFIG		0x06
#define	DACMD_WRITE_CONF2		0x3C
#define	DACMD_WRITE_CONFLABEL		0x49 /* Write configuration label */
#define	DACMD_WRITE_CONFIG_V3x		0x4F
#define	DACMD_ADD_CONFIG_V2x		0x18
#define	DACMD_ADD_CONFIG_V3x		0x4C
#define	DACMD_STORE_IMAGE		0x21
#define	DACMD_ADD_CAPACITY		0x2A /* add physical drives to existing array */
#define	DACMD_WRITE_IOPORT		0x3A /* write port B */
#define	DACMD_S2S_WRITEFULLCONF		0x60 /* write full configuration */
#define	DACMD_S2S_ADDFULLCONF		0x62 /* add   full configuration */
#define	DACMD_S2S_WRITELUNMAP_OLD	0x58 /* write LUN map information */
#define DACMD_S2S_WRITELUNMAP		0xD2 /* Write LUN MAP Information */
#define	DACMD_S2S_WRITE_IOPORT		0x66 /* write expanded IO port */
#define	DACMD_WRITE_V3x			0x34 /* write data from plain memory */
#define	DACMD_S2S_WRITESIG		0x4D /* write signature information */

#define MDACIOCTL_STOREIMAGE		0x2C /* Store the softeware image on controller */
#define MDACIOCTL_WRITESIGNATURE	0xA6 /* Write Controller Signature */
#define MDACIOCTL_SETREALTIMECLOCK	0xAC /* Set real time clock value */
#define MDACIOCTL_PASS_THRU_CDB		0xAD /* Set up a pass-through command */
#define MDACIOCTL_PASS_THRU_INITIATE	0xAE /* Initiates a pass-through read/write command (bi-directional) */
#define MDACIOCTL_CREATENEWCONF		0xC0 /* Create new configruation */
#define MDACIOCTL_ADDNEWCONF		0xC4 /* Add new logical/physical device to configruation */
#define MDACIOCTL_MORE			0xC6 /* Do MORE operation */
#define MDACIOCTL_SETPHYSDEVPARAMETER	0xC8 /* Set physical device parameters */
#define MDACIOCTL_SETLOGDEVPARAMETER	0xCF /* Set logical device parameters */
#define MDACIOCTL_SETCONTROLLERPARAMTER	0xD1 /* Set controller parameter */
#define MDACIOCTL_WRITESANMAP		0xD4 /* Set logical device LUN map */
#define MDACIOCTL_SETMACADDRESS		0xD5 /* Set controller MAC address */

    /*
    * qla2100_set_scsi_direction
    *      This routine will set the proper direction for vendor specific
    *      commands. 
    *
    *      Note: Vendors should modify this routine to set the proper 
    *      direction of the transfer if they used vendor specific commands.
    *
    * Input:
    *      ha = adapter block pointer.
    *      sp = SCSI Request Block structure pointer.
    *
    * Returns:
    *      0 = success, was able to issue command.
    */

     void qla2100_set_vend_direction(scsi_qla_host_t *ha, 
 			Scsi_Cmnd       *cmd, cmd_entry_t     *pkt) {
			/* This section added 10-JAN-2001 by Lethe. Required to facilitate SCSI
			   pass-through for flashing disk firmware, and direct disk writes under
			   Mylex 6.x and 5.x Firmware */
           	if( cmd->data_cmnd[0] == UCSCSI_DCMD_PASSTHRU) {
				pkt->control_flags = 0;
				switch (cmd->data_cmnd[2]) {
						case SCSI_WRITE6:
						case SCSI_WRITE10:
						case SCSI_WRITEBUFFER:
							pkt->control_flags |= BIT_6;
							break;
						default:
							pkt->control_flags |= BIT_5;
			    }
			} 
			else if( cmd->data_cmnd[0] == UCSCSI_DCMD )
			{
			    pkt->control_flags = 0;
			    switch( cmd->data_cmnd[2] )
			    {
				case DACMD_WRITE_CONF_ONDISK:
				case DACMD_WRITE_CONFIG:
				case DACMD_WRITE_CONF2:
				case DACMD_WRITE_CONFLABEL:
				case DACMD_WRITE_CONFIG_V3x:
				case DACMD_ADD_CONFIG_V2x:
				case DACMD_ADD_CONFIG_V3x:
				case DACMD_STORE_IMAGE:
				case DACMD_ADD_CAPACITY:
				case DACMD_WRITE_IOPORT:
				case DACMD_S2S_WRITEFULLCONF:
				case DACMD_S2S_ADDFULLCONF:
				case DACMD_S2S_WRITELUNMAP_OLD:
				case DACMD_S2S_WRITELUNMAP:
				case DACMD_S2S_WRITE_IOPORT:
				case DACMD_WRITE_V3x:
				case DACMD_S2S_WRITESIG:
					pkt->control_flags |= BIT_6;
					break;
				default:
					pkt->control_flags |= BIT_5;
			    }
			}

/*******************************************************************************************
* The below logic is required to operate correctly with Mylex (IBM's) DAC960 family of     *
* external RAID controllers.                                                               *
*                                                                                          *
* In addition to defining whether below CDBs are Reads or Writes, Mylex, in their infinite *
* wisdom, defined a vendor-specific CDB which can act as a Read OR a write, depending on   *
* the parameters sent in a previous MDACIOCTL_PASS_THRU_CDB.  Instead of adding a lot of   *
* logic to define and maintain a MDACIOCTL_PASS_THRU_CDB queue, and parse each one of them *
* to determine direction, I took easy way out (also the low-overhead method).              *
*                                                                                          *
* If the high-order bit of the 32-bit UniqueID, defined in byte 3 of data_cmnd[3] is set   *
* then I will mark that as a CDB which is going to be a write, otherwise the pass thru     *
* operation will be a read. If somebody wishes to rewrite the driver to maintain a 30-sec  *
* command queue, and parse the contents of each data buffer passed in to determine R or W  *
* then they are free to do so, and it will not impact future versions of the Distributed   *
* Array Manager, which required this fix in the first place.                               *
*                                                                                          *
* This configurator and patch was written by David A. Lethe of Xyratex david@santools.com. *
* In addition, the logic to check cmd->data_cmnd[0] == UC_SCSI_DCMD, was written by        *
* Sammy Wilborn of Silicon Graphics, Inc, and David Lethe                                  *
* They define CDBs used by the DAC960FF family, when running FW 7.x and above.             *
*                                                                                          *
*******************************************************************************************/

			else if ( cmd->data_cmnd[0] == UC_SCSI_DCMD ) /* Mylex DAC960 FW 7.x */
			{
			    pkt->control_flags = 0;
			    switch( cmd->data_cmnd[2] )
			    {
				case MDACIOCTL_STOREIMAGE:
				case MDACIOCTL_SETREALTIMECLOCK:
				case MDACIOCTL_WRITESIGNATURE:
			        case MDACIOCTL_CREATENEWCONF:
			        case MDACIOCTL_ADDNEWCONF:
			        case MDACIOCTL_MORE:
			        case MDACIOCTL_SETPHYSDEVPARAMETER:
			        case MDACIOCTL_SETLOGDEVPARAMETER:
			        case MDACIOCTL_SETCONTROLLERPARAMTER:
			        case MDACIOCTL_WRITESANMAP:
			        case MDACIOCTL_SETMACADDRESS:
				case MDACIOCTL_PASS_THRU_CDB:
					pkt->control_flags |= BIT_6;
					break;
				default:
					if (cmd->data_cmnd[2] == MDACIOCTL_PASS_THRU_INITIATE) {
					/* If the high bit of the UniqueID field of the vendor-
					   specific field is TRUE, then it is marked as a write. */
						if (cmd->data_cmnd[3] & 0x80)
							pkt->control_flags |= BIT_6;
						else
							pkt->control_flags |= BIT_5;
					}
					else
						pkt->control_flags |= BIT_5;
					break;
			    }
			}
			else
			{
                       		pkt->control_flags |= BIT_5;
			}

    }
